/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.util.SecurityContext;
import java.util.Collection;
import java.util.Set;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="verifier")
public abstract class JwtIssuer {
    public abstract String name();

    public abstract Set<String> audience();

    public abstract ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> var1, SecurityContext var2);

    public JwtConsumer createConsumer(Collection<Constraint> constraints, boolean requireSubjectClaim, SecurityContext context) {
        Set<String> audience;
        JwtConsumerBuilder builder = new JwtConsumerBuilder().setVerificationKeyResolver((VerificationKeyResolver)this.keyResolver(constraints, context)).setRequireExpirationTime();
        if (requireSubjectClaim) {
            builder.setRequireSubject();
        }
        if (!this.name().equals("*")) {
            builder.setExpectedIssuer(true, this.name());
        }
        if ((audience = this.audience()).isEmpty()) {
            builder.setSkipDefaultAudienceValidation();
        } else {
            builder = builder.setExpectedAudience(audience.toArray(new String[0]));
        }
        return builder.build();
    }
}

