/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JkuDomainWhitelist;
import io.confluent.security.authentication.oauthbearer.JkuVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.util.SecurityContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwt.consumer.JwtConsumer;

@JsonDeserialize(builder=Builder.class)
public final class JwtIssuerJku
extends JwtIssuer {
    private final String name;
    private final Set<String> audience;
    private final List<String> domainWhitelist;
    private final SimpleGet client;
    private JwtConsumer consumer;
    private Long retainCacheOnErrorDuration;

    private JwtIssuerJku(String name, Set<String> audience, List<String> domainWhitelist, SimpleGet client, long retainCacheOnErrorDuration) {
        this.name = name;
        this.audience = Collections.unmodifiableSet(audience);
        this.domainWhitelist = Collections.unmodifiableList(domainWhitelist);
        this.client = client;
        this.retainCacheOnErrorDuration = retainCacheOnErrorDuration;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonProperty(value="domainWhiteList")
    List<String> domainWhitelist() {
        return this.domainWhitelist;
    }

    @JsonProperty(value="retainCacheOnErrorDuration")
    long retainCacheOnErrorDuration() {
        return this.retainCacheOnErrorDuration;
    }

    @Override
    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints, SecurityContext context) {
        ArrayList<Constraint> jkuConstraints = new ArrayList<Constraint>(constraints);
        jkuConstraints.add(new JkuDomainWhitelist(this.domainWhitelist));
        return new ConstrainedVerificationKeyResolver(new JkuVerificationKeyResolver(this.client), jkuConstraints);
    }

    @Override
    public JwtConsumer createConsumer(Collection<Constraint> constraints, boolean requireSubjectClaim, SecurityContext context) {
        if (this.consumer == null) {
            this.consumer = super.createConsumer(constraints, requireSubjectClaim, context);
        }
        return this.consumer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Set<String> audience;
        private List<String> domainWhitelist = Collections.emptyList();
        private SimpleGet client;
        private long retainCacheOnErrorDuration = 0L;

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience", nulls=Nulls.AS_EMPTY)
        public Builder audience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        @JsonSetter(value="domainWhitelist", nulls=Nulls.AS_EMPTY)
        public Builder domainWhitelist(List<String> domainWhitelist) {
            this.domainWhitelist = domainWhitelist;
            return this;
        }

        @JsonSetter(value="retainCacheOnErrorDuration", nulls=Nulls.AS_EMPTY)
        public Builder retainCacheOnErrorDuration(long retainCacheOnErrorDuration) {
            this.retainCacheOnErrorDuration = retainCacheOnErrorDuration;
            return this;
        }

        Builder simpleGet(SimpleGet simpleGet) {
            this.client = simpleGet;
            return this;
        }

        public JwtIssuerJku build() {
            List normalizedDomainWhitelist = this.domainWhitelist.stream().map(String::toLowerCase).collect(Collectors.toList());
            return new JwtIssuerJku(this.name, this.audience == null ? Collections.emptySet() : this.audience, normalizedDomainWhitelist, (SimpleGet)(this.client == null ? new Get() : this.client), this.retainCacheOnErrorDuration);
        }
    }
}

