/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.util.SecurityContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

@JsonDeserialize(builder=Builder.class)
public final class JwtIssuerJwks
extends JwtIssuer {
    private final String name;
    private final Set<String> audience;
    private final String jwksUri;
    private final SimpleGet simpleGet;
    private JwtConsumer consumer;

    private JwtIssuerJwks(String name, Set<String> audience, String jwksUri, SimpleGet simpleGet) {
        this.name = name;
        this.audience = Collections.unmodifiableSet(audience);
        this.jwksUri = jwksUri;
        this.simpleGet = simpleGet;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonProperty(value="jwksUri")
    public String jwksUri() {
        return this.jwksUri;
    }

    @Override
    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints, SecurityContext context) {
        HttpsJwks httpsJwks = new HttpsJwks(this.jwksUri);
        httpsJwks.setSimpleHttpGet(this.simpleGet);
        HttpsJwksVerificationKeyResolver keyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
        return new ConstrainedVerificationKeyResolver((VerificationKeyResolver)keyResolver, constraints);
    }

    @Override
    public JwtConsumer createConsumer(Collection<Constraint> constraints, boolean requireSubjectClaim, SecurityContext context) {
        if (this.consumer == null) {
            this.consumer = super.createConsumer(constraints, requireSubjectClaim, context);
        }
        return this.consumer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Set<String> audience;
        private String jwksUri;
        private SimpleGet client;

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience", nulls=Nulls.AS_EMPTY)
        public Builder audience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        @JsonProperty(value="jwksUri")
        public Builder jwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        Builder simpleGet(SimpleGet simpleGet) {
            this.client = simpleGet;
            return this;
        }

        public JwtIssuerJwks build() {
            Objects.requireNonNull(this.jwksUri, "jwksUri must not be null");
            Objects.requireNonNull(this.name, "name must not be null");
            return new JwtIssuerJwks(this.name, this.audience == null ? Collections.emptySet() : this.audience, this.jwksUri, (SimpleGet)(this.client == null ? new Get() : this.client));
        }
    }
}

