/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.credential.HttpBearerCredential;
import io.confluent.security.authentication.credential.HttpCredential;
import io.confluent.security.authentication.http.ConfluentSecurityContext;
import io.confluent.security.authentication.http.HttpAuthenticatorJwt;
import io.confluent.security.authentication.oauthbearer.JwtPrincipal;
import io.confluent.security.authentication.oauthbearer.TrustServiceClient;
import io.confluent.security.trustservice.entities.v1.AssumePrincipalData;
import io.confluent.security.trustservice.entities.v1.AssumePrincipalRequest;
import io.confluent.security.trustservice.entities.v1.AssumePrincipalResponse;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class TrustServiceBearerServerAuthFilter
implements ContainerRequestFilter {
    public static final String MDS_POOL_ID_KEY = "Confluent-Pool-Id";
    private static final Logger log = LoggerFactory.getLogger(TrustServiceBearerServerAuthFilter.class);
    private final TrustServiceClient client;
    private final HttpAuthenticatorJwt authenticator;

    public TrustServiceBearerServerAuthFilter(TrustServiceClient client, HttpAuthenticatorJwt authenticator) {
        this.client = client;
        this.authenticator = authenticator;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            HttpCredential credential = HttpCredential.read((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
            String poolId = (String)requestContext.getHeaders().getFirst((Object)MDS_POOL_ID_KEY);
            if (poolId == null) {
                poolId = "";
            }
            if (!(credential instanceof HttpBearerCredential)) {
                log.debug("HttpCredential should use Bearer scheme");
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                return;
            }
            AssumePrincipalRequest request = AssumePrincipalRequest.builder().token(credential.authParams()).identityPool(poolId).build();
            AssumePrincipalResponse response = this.client.validateToken(request);
            AssumePrincipalData data = response.value();
            if (data.expiresIn() <= 0L) {
                log.debug("Confluent token is expired, unable to authenticate request");
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                return;
            }
            HttpBearerCredential confluentToken = new HttpBearerCredential(data.token());
            JwtPrincipal principal = this.authenticator.authenticate(confluentToken);
            boolean isSecure = requestContext.getUriInfo().getRequestUri().toString().startsWith("https");
            requestContext.setSecurityContext((SecurityContext)new ConfluentSecurityContext(credential.scheme(), principal, isSecure));
        }
        catch (Throwable t) {
            log.debug("Unable to authenticate request");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }
}

