/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.credential.HttpBearerCredential;
import io.confluent.security.authentication.http.HttpClient;
import io.confluent.security.trustservice.entities.v1.AssumePrincipalRequest;
import io.confluent.security.trustservice.entities.v1.AssumePrincipalResponse;
import java.net.URI;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class TrustServiceClient {
    private HttpClient client;
    private URI tokenEndpoint;

    private TrustServiceClient(HttpClient client, URI tokenEndpoint) {
        this.client = client;
        this.tokenEndpoint = tokenEndpoint;
    }

    public AssumePrincipalResponse validateToken(AssumePrincipalRequest request) throws IllegalArgumentException {
        if (request.token() == null) {
            throw new IllegalArgumentException("AssumePrincipalRequest must have a non-null token value.");
        }
        Response response = this.client.target(this.tokenEndpoint, new HttpBearerCredential(request.token())).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)request));
        return (AssumePrincipalResponse)response.readEntity(AssumePrincipalResponse.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpClient client;
        private URI tokenEndpoint;

        public Builder client(HttpClient client) {
            this.client = client;
            return this;
        }

        public Builder authenticateEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public TrustServiceClient build() {
            return new TrustServiceClient(this.client, this.tokenEndpoint);
        }
    }
}

