/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.mtls;

import io.confluent.security.mtls.CertMetadataIdentifier;
import io.confluent.security.policyapi.cel.TrustPolicyCelLibrary;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import io.confluent.security.policyapi.exception.PolicyViolationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ListT;
import org.projectnessie.cel.common.types.NullT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.pb.ProtoTypeRegistry;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.TypeRegistry;
import org.projectnessie.cel.common.types.ref.Val;

public class CertIdentityPoolFilter {
    private static final Env ENV = CertIdentityPoolFilter.getEnv();
    private final Map<String, Program> cacheCompiledFilters = new ConcurrentHashMap<String, Program>();

    public boolean filter(String filter, Map<String, String> vars) {
        if (filter == null || filter.isEmpty()) {
            return false;
        }
        if (vars == null || vars.isEmpty()) {
            return false;
        }
        try {
            Program program = this.compilePolicy(filter);
            return CertIdentityPoolFilter.evaluatePolicy(program, vars);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void validate(String filter) {
        Program program = this.compilePolicy(filter);
        CertIdentityPoolFilter.evaluatePolicy(program, new HashMap<String, String>());
    }

    Program compilePolicy(String filter) {
        Env.AstIssuesTuple astIss;
        Program cache = this.cacheCompiledFilters.get(filter);
        if (cache != null) {
            return cache;
        }
        try {
            astIss = ENV.compile(filter);
        }
        catch (Throwable t) {
            throw new PolicyEngineException(String.format("Failed to load pool filter '%s'", filter), t);
        }
        if (astIss.hasIssues()) {
            throw new PolicyViolationException(String.format("Failed to load pool filter '%s', violation: %s", filter, astIss.getIssues().toString()));
        }
        Program program = ENV.program(astIss.getAst(), new ProgramOption[0]);
        this.cacheCompiledFilters.put(filter, program);
        return program;
    }

    static boolean evaluatePolicy(Program program, Map<String, String> vars) {
        Program.EvalResult evalResult = program.eval(vars);
        if (Err.isError((Val)evalResult.getVal())) {
            return false;
        }
        Val value = evalResult.getVal();
        if (value.type().typeEnum() != TypeEnum.Bool) {
            throw new PolicyEngineException(String.format("Pool filter fails to evaluate as boolean: %s", program));
        }
        return value.booleanValue();
    }

    private static Env getEnv() {
        List decls = CertMetadataIdentifier.IDENTIFIERS.stream().map(ident -> Decls.newVar((String)ident, (com.google.api.expr.v1alpha1.Type)Decls.String)).collect(Collectors.toList());
        EnvOption envOptionIdents = EnvOption.declarations(decls);
        EnvOption envOptionLib = TrustPolicyCelLibrary.customEnvOption();
        List<EnvOption> envOptions = Arrays.asList(envOptionIdents, envOptionLib);
        ProtoTypeRegistry typeRegistry = ProtoTypeRegistry.newEmptyRegistry();
        typeRegistry.registerType(new Type[]{NullT.NullType});
        typeRegistry.registerType(new Type[]{BoolT.BoolType});
        typeRegistry.registerType(new Type[]{StringT.StringType});
        typeRegistry.registerType(new Type[]{ListT.ListType});
        return Env.newCustomEnv((TypeRegistry)typeRegistry, envOptions);
    }
}

