/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.util;

import io.confluent.security.authentication.AuthenticationErrorInfo;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.AuthenticationExceptionReasonCodes;
import io.confluent.security.util.SecurityContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

public class JwtUtils {
    private static final Map<Integer, ErrorInfo> ERROR_MESSAGE_MAP = new HashMap<Integer, ErrorInfo>();
    private static final Map<String, ErrorInfo> MISC_ERROR_MESSAGE_MAP = new LinkedHashMap<String, ErrorInfo>();
    public static final String CLAIM_USER_ID = "userId";
    public static final String CLAIM_USER_RESOURCE_ID = "userResourceId";
    public static final String OAUTH_PROVIDER_ID = "providerId";
    public static final String OAUTH_POOL_ID = "identityPoolId";
    public static final String OAUTH_JWKS_ENDPOINT = "jwksEndpoint";

    private static Optional<String> mkMessage(List<ErrorInfo> errors) {
        if (errors == null || errors.size() == 0) {
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ErrorInfo error : errors) {
            sb.append(JwtUtils.mkMessage(error));
            sb.append(", ");
        }
        int sbLength = sb.length();
        if (sbLength > 0) {
            sb.delete(sbLength - 2, sbLength);
            sb.append("]");
            return Optional.of(sb.toString());
        }
        return Optional.empty();
    }

    private static String mkMessage(ErrorInfo error) {
        return String.format("[%s - %s, relatedClaims: %s, identityInfo: %s]", new Object[]{error.reasonCode(), error.details(), error.getRelatedClaims(), error.getIdentityInfo()});
    }

    private static MapSource getSourceSupplier(String key) {
        return source -> new AbstractMap.SimpleImmutableEntry(key, source.get(key));
    }

    public static List<Integer> errorCodes(Throwable t) {
        if (t instanceof InvalidJwtException) {
            InvalidJwtException ije = (InvalidJwtException)t;
            if (ije.getErrorDetails() == null) {
                return Collections.emptyList();
            }
            return ije.getErrorDetails().stream().map(ErrorCodeValidator.Error::getErrorCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String errorMessage(Throwable t) {
        return JwtUtils.errorDetails(t, new SecurityContext()).message();
    }

    public static Error errorDetails(Throwable t, SecurityContext context) {
        if (t == null) {
            return new Error("Exception is null", Collections.emptyList());
        }
        StringBuilder errorMessageSb = new StringBuilder();
        errorMessageSb.append(t.getClass().getSimpleName());
        LinkedList<ErrorInfo> errors = new LinkedList();
        if (t instanceof InvalidJwtException) {
            errors = JwtUtils.getInvalidJwtExceptionError((InvalidJwtException)t, errorMessageSb, context);
        } else if (t instanceof AuthenticationException) {
            errors = JwtUtils.getAuthenticationExceptionError((AuthenticationException)t, errorMessageSb, context);
        } else if (t instanceof IllegalArgumentException) {
            errors = JwtUtils.getIllegalArgExceptionError((IllegalArgumentException)t, errorMessageSb, context);
        }
        if (t.getCause() != null) {
            errorMessageSb.append(String.format(" -> %s", t.getCause().getClass().getSimpleName()));
        }
        return new Error(errorMessageSb.toString(), errors);
    }

    private static List<ErrorInfo> getInvalidJwtExceptionError(InvalidJwtException ije, StringBuilder errorMessageSb, SecurityContext context) {
        LinkedList<ErrorInfo> errors = new LinkedList<ErrorInfo>();
        for (int code : JwtUtils.errorCodes((Throwable)ije)) {
            ErrorInfo error = code == 17 ? JwtUtils.maybeFetchMiscellaneousInfo((Throwable)ije).orElse(ERROR_MESSAGE_MAP.get(code)) : ERROR_MESSAGE_MAP.getOrDefault(code, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_UNKNOWN_ERROR, code, "unknown error"));
            for (MapSource supplier : error.claimSuppliers()) {
                error.relatedClaims((Map.Entry)supplier.apply(JwtUtils.getClaimsMapSafely(ije)));
            }
            if (context != null) {
                for (MapSource supplier : ErrorInfo.IDENTITY_SUPPLIERS) {
                    error.identityInfo((Map.Entry)supplier.apply(context.getContextMap()));
                }
            }
            errors.add(error);
        }
        JwtUtils.mkMessage(errors).ifPresent(msg -> errorMessageSb.append(String.format(" - Headers: [%s], Additional Details: %s", JwtUtils.getHeaders(ije.getJwtContext().getJoseObjects()), msg)));
        return errors;
    }

    private static List<ErrorInfo> getAuthenticationExceptionError(AuthenticationException t, StringBuilder errorMessageSb, SecurityContext context) {
        String details = t.getMessage() + ", " + t.reasonCode().toLowerCase(Locale.getDefault()).replaceAll("_", " ");
        ErrorInfo error = ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.AUTHENTICATION_EXCEPTION, -1, details);
        if (context != null) {
            for (MapSource supplier : ErrorInfo.IDENTITY_SUPPLIERS) {
                error.identityInfo((Map.Entry)supplier.apply(context.getContextMap()));
            }
        }
        switch (t.reasonCode()) {
            case "CLAIM_ISSUER_POOL_FILTER_MISMATCH": 
            case "TOKEN_ISSUER_UNRECOGNIZED": {
                JwtUtils.getClaimFromAuthExceptionInfo(t.errorInfo(), "iss").ifPresent(error::relatedClaims);
            }
        }
        errorMessageSb.append(" ");
        errorMessageSb.append(JwtUtils.mkMessage(error));
        return Collections.singletonList(error);
    }

    private static List<ErrorInfo> getIllegalArgExceptionError(IllegalArgumentException t, StringBuilder errorMessageSb, SecurityContext context) {
        String details = t.getMessage();
        ErrorInfo error = ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.ILLEGAL_ARGUMENT_EXCEPTION, -1, details);
        if (context != null) {
            for (MapSource supplier : ErrorInfo.IDENTITY_SUPPLIERS) {
                error.identityInfo((Map.Entry)supplier.apply(context.getContextMap()));
            }
        }
        errorMessageSb.append(" ");
        errorMessageSb.append(JwtUtils.mkMessage(error));
        return Collections.singletonList(error);
    }

    private static Optional<Map.Entry<String, Object>> getClaimFromAuthExceptionInfo(AuthenticationErrorInfo errInfo, String key) {
        AuthenticationErrorInfo.JwtClaimsInfo claimsInfo;
        if (errInfo instanceof AuthenticationErrorInfo.JwtClaimsInfo && (claimsInfo = (AuthenticationErrorInfo.JwtClaimsInfo)errInfo).hasClaims()) {
            return Optional.of(new AbstractMap.SimpleImmutableEntry<String, Object>(key, claimsInfo.claims().get(key)));
        }
        return Optional.empty();
    }

    private static Optional<ErrorInfo> maybeFetchMiscellaneousInfo(Throwable t) {
        if (t == null) {
            return Optional.empty();
        }
        for (Map.Entry<String, ErrorInfo> miscError : MISC_ERROR_MESSAGE_MAP.entrySet()) {
            if (!t.getMessage().contains(miscError.getKey())) continue;
            ErrorInfo error = miscError.getValue();
            return Optional.of(error);
        }
        return Optional.empty();
    }

    private static String getHeaders(List<JsonWebStructure> joseObjects) {
        StringBuilder headers = new StringBuilder();
        for (JsonWebStructure jws : joseObjects) {
            headers.append(jws.getHeaders().getFullHeaderAsJsonString());
        }
        return headers.toString();
    }

    private static Map<String, Object> getClaimsMapSafely(InvalidJwtException ije) {
        return Optional.ofNullable(ije.getJwtContext()).map(JwtContext::getJwtClaims).map(JwtClaims::getClaimsMap).orElse(Collections.emptyMap());
    }

    static {
        ERROR_MESSAGE_MAP.put(1, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_EXPIRED, 1, "The JWT Expiration Time {exp} claim identified a time in the past.", Arrays.asList(JwtUtils.getSourceSupplier("exp"))));
        ERROR_MESSAGE_MAP.put(2, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_EXP_CLAIM_MISSING, 2, "The JWT had no Expiration Time {exp} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(3, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_IAT_CLAIM_MISSING, 3, "The JWT had no Issued At {iat} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(4, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_NBF_CLAIM_MISSING, 4, "The JWT had no Not Before {nbf} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(7, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_AUD_CLAIM_MISSING, 7, "The JWT had no Audience {aud} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(11, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_ISS_CLAIM_MISSING, 11, "The JWT had no Issuer {iss} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(13, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_JTI_CLAIM_MISSING, 13, "The JWT had no JWT Id {jti} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(14, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SUB_CLAIM_MISSING, 14, "The JWT had no Subject {sub} claim but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(5, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_EXP_CLAIM_TOO_FAR_IN_FUTURE, 5, "The JWT Expiration Time {exp} claim had a value that is too far into the future.", Arrays.asList(JwtUtils.getSourceSupplier("exp"))));
        ERROR_MESSAGE_MAP.put(8, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_AUD_CLAIM_INVALID, 8, "The JWT Audience {aud} claim has unexpected value."));
        ERROR_MESSAGE_MAP.put(12, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_ISS_CLAIM_INVALID, 12, "The JWT Issuer {iss} claim has unexpected value.", Arrays.asList(JwtUtils.getSourceSupplier("iss"))));
        ERROR_MESSAGE_MAP.put(15, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SUB_CLAIM_INVALID, 15, "The JWT Subject {sub} claim has unexpected value."));
        ERROR_MESSAGE_MAP.put(18, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_CLAIM_MALFORMED, 18, "A JWT claim is of the wrong type or otherwise malformed."));
        ERROR_MESSAGE_MAP.put(23, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_IAT_CLAIM_TOO_FAR_IN_FUTURE, 23, "The JWT Issued At {iat} claim has a value which is too far in the future.", Arrays.asList(JwtUtils.getSourceSupplier("iat"))));
        ERROR_MESSAGE_MAP.put(24, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_IAT_CLAIM_TOO_FAR_IN_PAST, 24, "The JWT Issued At {iat} claim has a value which is too far in the past.", Arrays.asList(JwtUtils.getSourceSupplier("iat"))));
        ERROR_MESSAGE_MAP.put(6, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_NBF_CLAIM_NOT_VALID_YET, 6, "The JWT Not Before claim {nbf} indicates that it is not yet valid.", Arrays.asList(JwtUtils.getSourceSupplier("nbf"))));
        ERROR_MESSAGE_MAP.put(21, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_TYP_CLAIM_MISSING, 21, "The type {typ} header parameter is missing but it is configured to require explicit typing."));
        ERROR_MESSAGE_MAP.put(22, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_TYP_CLAIM_INVALID, 22, "The type {typ} header parameter has unexpected value."));
        ERROR_MESSAGE_MAP.put(9, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SIGNATURE_VERIFICATION_FAILED, 9, "The JWS signature could not be successfully verified with the given key."));
        ERROR_MESSAGE_MAP.put(10, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SIGNATURE_MISSING, 10, "The JWS signature is missing but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(16, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_PAYLOAD_JSON_INVALID, 16, "The payload could not be parsed as json."));
        ERROR_MESSAGE_MAP.put(17, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_PROCESSING_FAILED, 17, AuthenticationExceptionReasonCodes.ErrorTypes.JWT_PROCESSING_FAILED.toString()));
        ERROR_MESSAGE_MAP.put(19, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_ENCRYPTION_MISSING, 19, "No JWE encryption present but it is configured to be required."));
        ERROR_MESSAGE_MAP.put(20, ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_INTEGRITY_PROTECTION_MISSING, 20, "The JWT is missing integrity protection {signature/MAC JWS or symmetric JWE} but it is configured to be required."));
        MISC_ERROR_MESSAGE_MAP.put("Unable to find a suitable verification key for JWS", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_HEADER_KID_LOOKUP_FAILED, 17, "The JWT header field Key Id {kid} is invalid as we could not find a suitable corresponding verification key."));
        MISC_ERROR_MESSAGE_MAP.put("Unable to validate JWS signature verification key", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_HEADER_ALG_INVALID, 17, "The JWT header field Algorithm {alg} is invalid as it is not allow listed."));
        MISC_ERROR_MESSAGE_MAP.put("Invalid Signature Verification Key Algorithm", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_HEADER_ALG_INVALID, 17, "The JWT header field Algorithm {alg} is invalid as it is not allow listed."));
        MISC_ERROR_MESSAGE_MAP.put("Invalid jku", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_HEADER_JKU_INVALID, 17, "The JWT header field JKU {jku} is invalid."));
        MISC_ERROR_MESSAGE_MAP.put("Cannot find issuer", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_ISS_CLAIM_LOOKUP_FAILED, 17, "Cannot find issuer {iss} in the system.", Arrays.asList(JwtUtils.getSourceSupplier("iss"))));
        MISC_ERROR_MESSAGE_MAP.put("Unable to get jwt bundle", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SUB_CLAIM_INVALID, 17, "The JWT subject {sub} is invalid"));
        MISC_ERROR_MESSAGE_MAP.put("Unable to get subject", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SUB_CLAIM_INVALID, 17, "The JWT subject {sub} is invalid"));
        MISC_ERROR_MESSAGE_MAP.put("Unable to parse the subject", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_SUB_CLAIM_INVALID, 17, "The JWT subject {sub} is invalid"));
        MISC_ERROR_MESSAGE_MAP.put("Unable to get kid", ErrorInfo.mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes.JWT_HEADER_KID_LOOKUP_FAILED, 17, "The JWT header field Key Id {kid} is not present"));
    }

    public static class Error {
        private final String message;
        private final List<ErrorInfo> errors;

        public Error(String message, List<ErrorInfo> errors) {
            this.message = message;
            this.errors = errors;
        }

        public String message() {
            return this.message;
        }

        public List<ErrorInfo> errors() {
            return this.errors;
        }

        public String toString() {
            return "Error {message: " + this.message + ",errors: " + this.errors + "}\n";
        }
    }

    public static class ErrorInfo {
        private final AuthenticationExceptionReasonCodes.ErrorTypes reasonCode;
        private final Integer joseErrorCode;
        private final String details;
        private final Map<String, Object> relatedClaims;
        private final Map<String, Object> identityInfo = new HashMap<String, Object>();
        private final List<MapSource> claimSuppliers;
        public static final List<MapSource> IDENTITY_SUPPLIERS = Arrays.asList(JwtUtils.access$000("identityPoolId"), JwtUtils.access$000("providerId"));

        public ErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes reasonCode, Integer joseErrorCode, String details, Map<String, Object> relatedClaims, List<MapSource> claimSuppliers) {
            this.reasonCode = reasonCode;
            this.joseErrorCode = joseErrorCode;
            this.details = details;
            this.relatedClaims = relatedClaims == null ? new HashMap() : relatedClaims;
            this.claimSuppliers = claimSuppliers == null ? Collections.emptyList() : claimSuppliers;
        }

        public boolean equals(Object errorInfo) {
            if (!(errorInfo instanceof ErrorInfo)) {
                return false;
            }
            ErrorInfo that = (ErrorInfo)errorInfo;
            return this.reasonCode == that.reasonCode && this.joseErrorCode.equals(that.joseErrorCode) && this.details.equals(that.details) && this.relatedClaims.equals(that.relatedClaims) && this.identityInfo.equals(that.identityInfo);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.reasonCode, this.joseErrorCode, this.details, this.relatedClaims, this.identityInfo});
        }

        public static ErrorInfo mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes reasonCode, Integer joseErrorCode, String details) {
            return ErrorInfo.mkErrorInfo(reasonCode, joseErrorCode, details, null, null);
        }

        public static ErrorInfo mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes reasonCode, Integer joseErrorCode, String details, List<MapSource> suppliers) {
            return ErrorInfo.mkErrorInfo(reasonCode, joseErrorCode, details, null, suppliers);
        }

        public static ErrorInfo mkErrorInfo(AuthenticationExceptionReasonCodes.ErrorTypes reasonCode, Integer joseErrorCode, String details, Map<String, Object> relatedClaims, List<MapSource> suppliers) {
            ArrayList<MapSource> allSuppliers = new ArrayList<MapSource>();
            if (suppliers != null) {
                allSuppliers.addAll(suppliers);
            }
            allSuppliers.add(JwtUtils.getSourceSupplier(JwtUtils.CLAIM_USER_ID));
            allSuppliers.add(JwtUtils.getSourceSupplier(JwtUtils.CLAIM_USER_RESOURCE_ID));
            return new ErrorInfo(reasonCode, joseErrorCode, details, relatedClaims, allSuppliers);
        }

        public AuthenticationExceptionReasonCodes.ErrorTypes reasonCode() {
            return this.reasonCode;
        }

        public String details() {
            return this.details;
        }

        public void relatedClaims(String key, Object value) {
            this.relatedClaims.put(key, value);
        }

        public void relatedClaims(Map.Entry<String, Object> entry) {
            this.relatedClaims(entry.getKey(), entry.getValue());
        }

        public List<MapSource> claimSuppliers() {
            return Collections.unmodifiableList(this.claimSuppliers);
        }

        public void identityInfo(String key, Object value) {
            this.identityInfo.put(key, value);
        }

        public void identityInfo(Map.Entry<String, Object> entry) {
            this.identityInfo(entry.getKey(), entry.getValue());
        }

        public Map<String, Object> getIdentityInfo() {
            return Collections.unmodifiableMap(this.identityInfo);
        }

        public Map<String, Object> getRelatedClaims() {
            return Collections.unmodifiableMap(this.relatedClaims);
        }

        public String toString() {
            return "ErrorInfo {reasonCode: " + (Object)((Object)this.reasonCode) + ", joseErrorCode: " + this.joseErrorCode + ", relatedClaims: " + this.relatedClaims + ", identityInfo: " + this.identityInfo + ", details: " + this.details + "}\n";
        }
    }

    private static interface MapSource
    extends Function<Map<String, Object>, Map.Entry<String, Object>> {
    }
}

