/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.credential;

import io.confluent.security.authentication.credential.Credential;
import io.confluent.security.authentication.credential.HttpAnonymousCredential;
import io.confluent.security.authentication.credential.HttpBasicCredential;
import io.confluent.security.authentication.credential.HttpBearerCredential;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpCredential
extends Credential {
    private static final Logger log = LoggerFactory.getLogger(HttpCredential.class);

    public abstract Scheme scheme();

    public abstract Credential credential();

    public abstract String authParams();

    public static HttpCredential read(String authorizationHeader) {
        if (authorizationHeader == null) {
            return new HttpAnonymousCredential();
        }
        String[] tokens = authorizationHeader.split("\\s+", 2);
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Malformed Authorization header");
        }
        return HttpCredential.factory(tokens[0], tokens[1]);
    }

    static HttpCredential factory(String scheme, String authInfo) {
        switch (Scheme.from(scheme).ordinal()) {
            case 1: {
                return new HttpBasicCredential(authInfo);
            }
            case 2: {
                return new HttpBearerCredential(authInfo);
            }
        }
        throw new IllegalArgumentException("Unrecognized authentication scheme " + scheme);
    }

    public String toString() {
        return String.valueOf((Object)this.scheme()) + " [REDACTED]";
    }

    public static enum Scheme {
        NONE("None"),
        BASIC("Basic"),
        BEARER("Bearer");

        private final String text;

        private Scheme(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static Scheme from(String scheme) {
            switch (scheme.toLowerCase(Locale.US)) {
                case "none": {
                    return NONE;
                }
                case "basic": {
                    return BASIC;
                }
                case "bearer": {
                    return BEARER;
                }
            }
            throw new IllegalArgumentException("Unrecognized scheme " + scheme);
        }
    }
}

