/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.resource.Resource;
import io.cucumber.junit.platform.engine.FeatureParserWithSource;
import io.cucumber.junit.platform.engine.FeatureSource;
import io.cucumber.junit.platform.engine.FeatureWithSource;
import java.util.Optional;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class FeatureParserWithIssueReporting {
    private final FeatureParserWithSource delegate;
    private final DiscoveryIssueReporter issueReporter;

    FeatureParserWithIssueReporting(FeatureParserWithSource delegate, DiscoveryIssueReporter issueReporter) {
        this.delegate = delegate;
        this.issueReporter = issueReporter;
    }

    Optional<FeatureWithSource> parseResource(Resource resource) {
        try {
            return this.delegate.parseResource(resource);
        }
        catch (FeatureParserException e) {
            FeatureSource featureSource = FeatureSource.of(resource.getUri());
            this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)e.getMessage()).cause(e.getCause()).source(featureSource.source()));
            return Optional.empty();
        }
    }
}

