/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberDiscoverySelectors;
import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.DiscoverySelectorResolver;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class FeaturesPropertyResolver {
    private final DiscoverySelectorResolver delegate;

    FeaturesPropertyResolver(DiscoverySelectorResolver delegate) {
        this.delegate = delegate;
    }

    void resolveSelectors(EngineDiscoveryRequest request, CucumberEngineDescriptor engineDescriptor, DiscoveryIssueReporter issueReporter) {
        ConfigurationParameters configuration = request.getConfigurationParameters();
        CucumberConfiguration options = new CucumberConfiguration(configuration, issueReporter);
        Set<CucumberDiscoverySelectors.FeatureWithLinesSelector> selectors = options.featuresWithLines();
        if (selectors.isEmpty()) {
            this.delegate.resolveSelectors(request, engineDescriptor, issueReporter);
            return;
        }
        issueReporter.reportIssue(FeaturesPropertyResolver.createCucumberFeaturesPropertyIsUsedIssue());
        FeaturesPropertyDiscoveryRequest replacement = new FeaturesPropertyDiscoveryRequest(request, selectors);
        this.delegate.resolveSelectors(replacement, engineDescriptor, issueReporter);
    }

    private static DiscoveryIssue createCucumberFeaturesPropertyIsUsedIssue() {
        return DiscoveryIssue.create((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)"Discovering tests using the cucumber.features property. Other discovery selectors are ignored!\n\nThis is a work around for the limited JUnit 5 support in Maven and Gradle. Please request/upvote/sponsor/ect better support for JUnit 5 discovery selectors. For details see: https://github.com/cucumber/cucumber-jvm/pull/2498\n\nIf you are using the JUnit 5 Suite Engine, Platform Launcher API or Console Launcher you should not use this property. Please consult the JUnit 5 documentation on test selection.");
    }

    private static class FeaturesPropertyDiscoveryRequest
    implements EngineDiscoveryRequest {
        private final EngineDiscoveryRequest delegate;
        private final Set<? extends DiscoverySelector> selectors;

        public FeaturesPropertyDiscoveryRequest(EngineDiscoveryRequest delegate, Set<? extends DiscoverySelector> selectors) {
            this.delegate = delegate;
            this.selectors = selectors;
        }

        public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> selectorType) {
            Objects.requireNonNull(selectorType);
            return this.selectors.stream().filter(selectorType::isInstance).map(selectorType::cast).collect(Collectors.toList());
        }

        public <T extends DiscoveryFilter<?>> List<T> getFiltersByType(Class<T> filterType) {
            return this.delegate.getFiltersByType(filterType);
        }

        public ConfigurationParameters getConfigurationParameters() {
            return this.delegate.getConfigurationParameters();
        }
    }
}

