/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.junit.platform.engine.CucumberTestDescriptor;
import io.cucumber.junit.platform.engine.DescriptorOrderingStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.UnaryOperator;
import org.junit.platform.engine.ConfigurationParameters;

enum DefaultDescriptorOrderingStrategy implements DescriptorOrderingStrategy
{
    LEXICAL{

        @Override
        public UnaryOperator<List<CucumberTestDescriptor>> create(ConfigurationParameters configuration) {
            return pickles -> {
                pickles.sort(lexical);
                return pickles;
            };
        }
    }
    ,
    REVERSE{

        @Override
        public UnaryOperator<List<CucumberTestDescriptor>> create(ConfigurationParameters configuration) {
            return pickles -> {
                pickles.sort(lexical.reversed());
                return pickles;
            };
        }
    }
    ,
    RANDOM{

        @Override
        public UnaryOperator<List<CucumberTestDescriptor>> create(ConfigurationParameters configuration) {
            long seed = configuration.get("cucumber.execution.order.random.seed", Long::decode).orElseGet(this::createRandomSeed);
            Random random = new Random(seed);
            return testDescriptors -> {
                testDescriptors.sort(lexical);
                Collections.shuffle(testDescriptors, random);
                return testDescriptors;
            };
        }

        private long createRandomSeed() {
            long generatedSeed = Math.abs(new Random().nextLong());
            log.config(() -> String.format("Using generated seed for configuration parameter '%s' with value '%s'.", "cucumber.execution.order.random.seed", generatedSeed));
            return generatedSeed;
        }
    };

    private static final Logger log;
    private static final Comparator<CucumberTestDescriptor> lexical;

    static DefaultDescriptorOrderingStrategy getStrategy(ConfigurationParameters configurationParameters) {
        return DefaultDescriptorOrderingStrategy.valueOf(configurationParameters.get("cucumber.execution.order").orElse("lexical").toUpperCase(Locale.ROOT));
    }

    static {
        log = LoggerFactory.getLogger(DefaultDescriptorOrderingStrategy.class);
        lexical = Comparator.comparing(CucumberTestDescriptor::getUri).thenComparing(CucumberTestDescriptor::getLocation);
    }
}

