/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.StringUtils;
import java.util.Objects;

final class Line {
    private final String rawText;
    private final boolean empty;
    private final String text;
    private final int indent;
    private final int textLength;

    Line(String rawText) {
        this.rawText = Objects.requireNonNull(rawText);
        StringUtils.IndentedText trimmedIndent = StringUtils.trimAndIndent(rawText);
        this.text = trimmedIndent.getText();
        this.indent = trimmedIndent.getIndent();
        this.textLength = this.text.length();
        this.empty = this.text.isEmpty();
    }

    int getIndent() {
        return this.indent;
    }

    String getText() {
        return this.text;
    }

    String getRawText() {
        return this.rawText;
    }

    String getRawTextSubstring(int indentToRemove) {
        return this.rawText.substring(this.rawText.offsetByCodePoints(0, indentToRemove));
    }

    boolean isEmpty() {
        return this.empty;
    }

    boolean startsWith(String prefix) {
        return this.text.startsWith(prefix);
    }

    boolean startsWith(char prefix) {
        return !this.empty && this.text.charAt(0) == prefix;
    }

    String substringTrimmed(int beginIndex) {
        return StringUtils.substringAndLeftTrim(this.text, beginIndex, this.textLength);
    }

    boolean startsWithTitleKeyword(String keyword) {
        int keywordLength = keyword.length();
        return this.textLength > keywordLength && this.text.charAt(keywordLength) == ':' && this.text.startsWith(keyword);
    }
}

