/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.EncodingParser;
import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.PickleCompiler;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import io.cucumber.messages.types.SourceReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GherkinParser {
    static final int FEATURE_FILE_AVERAGE_LINE_LENGTH = 100;
    static final int FEATURE_FILE_AVERAGE_LINE_COUNT = 2048;
    static final int FEATURE_FILE_AVERAGE_SIZE = 204800;
    private final boolean includeSource;
    private final boolean includeGherkinDocument;
    private final boolean includePickles;
    private final IdGenerator idGenerator;
    private final PickleCompiler pickleCompiler;

    private GherkinParser(boolean includeSource, boolean includeGherkinDocument, boolean includePickles, IdGenerator idGenerator) {
        this.includeSource = includeSource;
        this.includeGherkinDocument = includeGherkinDocument;
        this.includePickles = includePickles;
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.pickleCompiler = new PickleCompiler(idGenerator);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Stream<Envelope> parse(Path source) throws IOException {
        Objects.requireNonNull(source);
        return this.parse(source.toUri().toString(), Files.readAllBytes(source));
    }

    public Stream<Envelope> parse(String uri, InputStream source) throws IOException {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(source);
        return this.parse(uri, source.readAllBytes());
    }

    public Stream<Envelope> parse(String uri, byte[] source) {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(source);
        String withEncodingFromSource = EncodingParser.readWithEncodingFromSource(source);
        return this.parse(Envelope.of((Source)new Source(uri, withEncodingFromSource, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN)));
    }

    public Stream<Envelope> parse(Envelope envelope) {
        Objects.requireNonNull(envelope);
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        if (this.includeSource) {
            messages.add(envelope);
        }
        envelope.getSource().map(this::parse).ifPresent(envelopes -> messages.addAll((Collection<Envelope>)envelopes));
        return messages.stream();
    }

    private List<Envelope> parse(Source source) {
        return this.parse(source.getUri(), source.getData());
    }

    private List<Envelope> parse(String uri, String data) {
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        GherkinDocumentBuilder documentBuilder = new GherkinDocumentBuilder(this.idGenerator, uri);
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(documentBuilder);
        try {
            GherkinDocument gherkinDocument = parser.parse(data, uri);
            if (this.includeGherkinDocument) {
                messages.add(Envelope.of((GherkinDocument)gherkinDocument));
            }
            if (this.includePickles) {
                List<Pickle> compile = this.pickleCompiler.compile(gherkinDocument, uri);
                int compileSize = compile.size();
                for (int i = 0; i < compileSize; ++i) {
                    Pickle pickle = compile.get(i);
                    messages.add(Envelope.of((Pickle)pickle));
                }
            }
        }
        catch (ParserException.CompositeParserException composite) {
            messages.addAll(composite.errors.stream().map(error -> this.createParseError((ParserException)error, uri)).collect(Collectors.toList()));
        }
        catch (ParserException error2) {
            messages.add(this.createParseError(error2, uri));
        }
        return messages;
    }

    private Envelope createParseError(ParserException e, String uri) {
        return Envelope.of((ParseError)new ParseError(new SourceReference(uri, null, null, e.location), Objects.requireNonNull(e.getMessage())));
    }

    public static final class Builder {
        private boolean includeSource = true;
        private boolean includeGherkinDocument = true;
        private boolean includePickles = true;
        private IdGenerator idGenerator = () -> UUID.randomUUID().toString();

        private Builder() {
        }

        public Builder includeSource(boolean includeSource) {
            this.includeSource = includeSource;
            return this;
        }

        public Builder includeGherkinDocument(boolean includeGherkinDocument) {
            this.includeGherkinDocument = includeGherkinDocument;
            return this;
        }

        public Builder includePickles(boolean includePickles) {
            this.includePickles = includePickles;
            return this;
        }

        public Builder idGenerator(IdGenerator idGenerator) {
            this.idGenerator = Objects.requireNonNull(idGenerator);
            return this;
        }

        public GherkinParser build() {
            return new GherkinParser(this.includeSource, this.includeGherkinDocument, this.includePickles, this.idGenerator);
        }
    }
}

