/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.KeywordMatcher;
import io.cucumber.gherkin.KeywordMatchers;
import io.cucumber.gherkin.Line;
import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.TableRowLine;
import io.cucumber.gherkin.TagLine;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.StepKeywordType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

final class GherkinTokenMatcher
implements Parser.TokenMatcher {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^#\\s*language\\s*:\\s*([a-zA-Z\\-_]+)\\s*$");
    private final String defaultLanguage;
    private final Map<String, KeywordMatcher> activeKeywordMatchers = new HashMap<String, KeywordMatcher>(2);
    private @Nullable String currentLanguage;
    private KeywordMatcher currentKeywordMatcher;
    private @Nullable String activeDocStringSeparator = null;
    private int indentToRemove = 0;

    GherkinTokenMatcher(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        this.currentKeywordMatcher = this.requireKeywordMatcher(defaultLanguage, new Location(Integer.valueOf(0), Integer.valueOf(0)));
        this.reset();
    }

    GherkinTokenMatcher() {
        this("en");
    }

    @Override
    public void reset() {
        this.activeDocStringSeparator = null;
        this.indentToRemove = 0;
        this.setLanguageMatched(this.defaultLanguage, null);
    }

    private void setLanguageMatched(String language, @Nullable Location location) {
        if (language.equals(this.currentLanguage)) {
            return;
        }
        KeywordMatcher keywordMatcher = this.requireKeywordMatcher(language, location);
        this.currentLanguage = language;
        this.currentKeywordMatcher = keywordMatcher;
    }

    private KeywordMatcher requireKeywordMatcher(String language, @Nullable Location location) {
        KeywordMatcher keywordMatcher = this.activeKeywordMatchers.computeIfAbsent(language, KeywordMatchers::of);
        if (keywordMatcher == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return keywordMatcher;
    }

    private void setTokenMatched(Token token, Parser.TokenType matchedType, @Nullable String text, @Nullable String keyword, int indent, @Nullable StepKeywordType keywordType, @Nullable List<LineSpan> items) {
        token.matchedType = matchedType;
        token.matchedKeyword = keyword;
        token.keywordType = keywordType;
        token.matchedText = text;
        token.matchedItems = items;
        token.matchedLanguage = this.currentLanguage;
        token.matchedIndent = indent;
        token.location = Locations.atColumn(token.location, token.matchedIndent + 1);
    }

    @Override
    public boolean match_EOF(Token token) {
        if (!token.isEOF()) {
            return false;
        }
        this.setTokenMatched(token, Parser.TokenType.EOF, null, null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Other(Token token) {
        String text = this.removeDocStringIndent(token);
        this.setTokenMatched(token, Parser.TokenType.Other, this.unescapeDocString(text), null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Empty(Token token) {
        if (!token.getRequiredLine().isEmpty()) {
            return false;
        }
        this.setTokenMatched(token, Parser.TokenType.Empty, null, null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Comment(Token token) {
        Line line = token.getRequiredLine();
        if (!line.startsWith('#')) {
            return false;
        }
        String text = line.getRawText();
        this.setTokenMatched(token, Parser.TokenType.Comment, text, null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Language(Token token) {
        Line line = token.getRequiredLine();
        if (!line.startsWith('#')) {
            return false;
        }
        Matcher matcher = LANGUAGE_PATTERN.matcher(line.getText());
        if (!matcher.matches()) {
            return false;
        }
        String language = matcher.group(1);
        this.setTokenMatched(token, Parser.TokenType.Language, language, null, line.getIndent(), null, null);
        this.setLanguageMatched(language, token.location);
        return true;
    }

    @Override
    public boolean match_TagLine(Token token) {
        Line line = token.getRequiredLine();
        if (!line.startsWith('@')) {
            return false;
        }
        List<LineSpan> tags = TagLine.parse(line.getIndent(), line.getText(), token.location);
        this.setTokenMatched(token, Parser.TokenType.TagLine, null, null, line.getIndent(), null, tags);
        return true;
    }

    @Override
    public boolean match_FeatureLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.FeatureLine, this.currentKeywordMatcher::matchFeatureKeyword);
    }

    @Override
    public boolean match_RuleLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RuleLine, this.currentKeywordMatcher::matchRuleKeyword);
    }

    @Override
    public boolean match_BackgroundLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.BackgroundLine, this.currentKeywordMatcher::matchBackgroundKeyword);
    }

    @Override
    public boolean match_ScenarioLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ScenarioLine, this.currentKeywordMatcher::matchScenarioKeyword);
    }

    @Override
    public boolean match_ExamplesLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ExamplesLine, this.currentKeywordMatcher::matchExampleKeyword);
    }

    private boolean matchTitleLine(Token token, Parser.TokenType tokenType, Function<Line, @Nullable KeywordMatcher.Match> matcher) {
        Line line = token.getRequiredLine();
        KeywordMatcher.Match match = matcher.apply(line);
        if (match == null) {
            return false;
        }
        String keyword = match.getKeyword();
        int keywordLength = match.getKeywordLength();
        String title = line.substringTrimmed(keywordLength);
        this.setTokenMatched(token, tokenType, title, keyword, line.getIndent(), null, null);
        return true;
    }

    @Override
    public boolean match_DocStringSeparator(Token token) {
        return this.activeDocStringSeparator == null ? this.match_DocStringSeparator(token, "\"\"\"", true) || this.match_DocStringSeparator(token, "```", true) : this.match_DocStringSeparator(token, this.activeDocStringSeparator, false);
    }

    private boolean match_DocStringSeparator(Token token, String separator, boolean isOpen) {
        Line line = token.getRequiredLine();
        if (!line.startsWith(separator)) {
            return false;
        }
        String mediaType = null;
        if (isOpen) {
            mediaType = line.substringTrimmed(separator.length());
            this.activeDocStringSeparator = separator;
            this.indentToRemove = line.getIndent();
        } else {
            this.activeDocStringSeparator = null;
            this.indentToRemove = 0;
        }
        this.setTokenMatched(token, Parser.TokenType.DocStringSeparator, mediaType, separator, line.getIndent(), null, null);
        return true;
    }

    @Override
    public boolean match_StepLine(Token token) {
        Line line = token.getRequiredLine();
        KeywordMatcher.StepMatch match = this.currentKeywordMatcher.matchStepKeyword(line);
        if (match == null) {
            return false;
        }
        String keyword = match.getKeyword();
        int keywordLength = match.getKeywordLength();
        StepKeywordType keywordType = match.getKeywordType();
        String stepText = line.substringTrimmed(keywordLength);
        this.setTokenMatched(token, Parser.TokenType.StepLine, stepText, keyword, line.getIndent(), keywordType, null);
        return true;
    }

    @Override
    public boolean match_TableRow(Token token) {
        Line line = token.getRequiredLine();
        if (!line.startsWith('|')) {
            return false;
        }
        List<LineSpan> tableCells = TableRowLine.parse(line.getIndent(), line.getText());
        this.setTokenMatched(token, Parser.TokenType.TableRow, null, null, line.getIndent(), null, tableCells);
        return true;
    }

    private String removeDocStringIndent(Token token) {
        Line line = token.getRequiredLine();
        if (this.activeDocStringSeparator == null) {
            return line.getRawText();
        }
        if (this.indentToRemove > line.getIndent()) {
            return line.getText();
        }
        return line.getRawTextSubstring(this.indentToRemove);
    }

    private String unescapeDocString(String text) {
        if ("\"\"\"".equals(this.activeDocStringSeparator)) {
            return text.replace("\\\"\\\"\\\"", "\"\"\"");
        }
        if ("```".equals(this.activeDocStringSeparator)) {
            return text.replace("\\`\\`\\`", "```");
        }
        return text;
    }
}

