/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Line;
import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class Token {
    final @Nullable Line line;
    final boolean eof;
    @Nullable Parser.TokenType matchedType;
    @Nullable String matchedKeyword;
    @Nullable String matchedText;
    @Nullable List<LineSpan> matchedItems;
    int matchedIndent;
    @Nullable String matchedLanguage;
    @Nullable StepKeywordType keywordType;
    Location location;

    private Token(@Nullable Line line, Location location) {
        this.line = line;
        this.location = location;
        this.eof = line == null;
    }

    static Token createEOF(Location location) {
        Objects.requireNonNull(location);
        return new Token(null, location);
    }

    static Token createGherkinLine(String text, Location location) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(location);
        return new Token(new Line(text), location);
    }

    boolean isEOF() {
        return this.eof;
    }

    String getTokenValue() {
        return this.line == null ? "EOF" : this.line.getText();
    }

    public String toString() {
        return "%s: %s/%s".formatted(new Object[]{this.matchedType, this.matchedKeyword, this.matchedText});
    }

    String getRequiredMatchedKeyword() {
        return Objects.requireNonNull(this.matchedKeyword);
    }

    String getRequiredMatchedText() {
        return Objects.requireNonNull(this.matchedText);
    }

    String getRequiredMatchedLanguage() {
        return Objects.requireNonNull(this.matchedLanguage);
    }

    Parser.TokenType getRequiredMatchedType() {
        return Objects.requireNonNull(this.matchedType);
    }

    Line getRequiredLine() {
        return Objects.requireNonNull(this.line);
    }
}

