/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Envelope;
import java.io.BufferedWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MessageToNdjsonWriter
implements AutoCloseable,
Flushable {
    private final Writer writer;
    private final Serializer serializer;

    public MessageToNdjsonWriter(OutputStream outputStream, Serializer serializer) {
        this(MessageToNdjsonWriter.createBufferedOutputStreamWriter(outputStream), Objects.requireNonNull(serializer));
    }

    private static BufferedWriter createBufferedOutputStreamWriter(OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        return new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    private MessageToNdjsonWriter(Writer writer, Serializer serializer) {
        this.writer = writer;
        this.serializer = serializer;
    }

    public void write(Envelope message) throws IOException {
        Objects.requireNonNull(message);
        this.serializer.writeValue(this.writer, message);
        this.writer.write("\n");
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @FunctionalInterface
    public static interface Serializer {
        public void writeValue(Writer var1, Envelope var2) throws IOException;
    }
}

