/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Exception {
    private final String type;
    private final @Nullable String message;
    private final @Nullable String stackTrace;

    public Exception(String type, @Nullable String message, @Nullable String stackTrace) {
        this.type = Objects.requireNonNull(type, "Exception.type cannot be null");
        this.message = message;
        this.stackTrace = stackTrace;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Optional<String> getStackTrace() {
        return Optional.ofNullable(this.stackTrace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exception that = (Exception)o;
        return this.type.equals(that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message, this.stackTrace);
    }

    public String toString() {
        return "Exception{type=" + this.type + ", message=" + this.message + ", stackTrace=" + this.stackTrace + "}";
    }
}

