/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Location {
    private final Integer line;
    private final @Nullable Integer column;

    public Location(Integer line, @Nullable Integer column) {
        this.line = Objects.requireNonNull(line, "Location.line cannot be null");
        this.column = column;
    }

    public Integer getLine() {
        return this.line;
    }

    public Optional<Integer> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location that = (Location)o;
        return this.line.equals(that.line) && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return "Location{line=" + this.line + ", column=" + this.column + "}";
    }
}

