/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Git {
    private final String remote;
    private final String revision;
    private final @Nullable String branch;
    private final @Nullable String tag;

    public Git(String remote, String revision, @Nullable String branch, @Nullable String tag) {
        this.remote = Objects.requireNonNull(remote, "Git.remote cannot be null");
        this.revision = Objects.requireNonNull(revision, "Git.revision cannot be null");
        this.branch = branch;
        this.tag = tag;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRevision() {
        return this.revision;
    }

    public Optional<String> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Git that = (Git)o;
        return this.remote.equals(that.remote) && this.revision.equals(that.revision) && Objects.equals(this.branch, that.branch) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.remote, this.revision, this.branch, this.tag);
    }

    public String toString() {
        return "Git{remote=" + this.remote + ", revision=" + this.revision + ", branch=" + this.branch + ", tag=" + this.tag + "}";
    }
}

