/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.JavaMethod;
import io.cucumber.messages.types.JavaStackTraceElement;
import io.cucumber.messages.types.Location;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class SourceReference {
    private final @Nullable String uri;
    private final @Nullable JavaMethod javaMethod;
    private final @Nullable JavaStackTraceElement javaStackTraceElement;
    private final @Nullable Location location;

    public static SourceReference of(String uri) {
        return new SourceReference(Objects.requireNonNull(uri, "SourceReference.uri cannot be null"), null, null, null);
    }

    public static SourceReference of(JavaMethod javaMethod) {
        return new SourceReference(null, Objects.requireNonNull(javaMethod, "SourceReference.javaMethod cannot be null"), null, null);
    }

    public static SourceReference of(JavaStackTraceElement javaStackTraceElement) {
        return new SourceReference(null, null, Objects.requireNonNull(javaStackTraceElement, "SourceReference.javaStackTraceElement cannot be null"), null);
    }

    public static SourceReference of(Location location) {
        return new SourceReference(null, null, null, Objects.requireNonNull(location, "SourceReference.location cannot be null"));
    }

    public SourceReference(@Nullable String uri, @Nullable JavaMethod javaMethod, @Nullable JavaStackTraceElement javaStackTraceElement, @Nullable Location location) {
        this.uri = uri;
        this.javaMethod = javaMethod;
        this.javaStackTraceElement = javaStackTraceElement;
        this.location = location;
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<JavaMethod> getJavaMethod() {
        return Optional.ofNullable(this.javaMethod);
    }

    public Optional<JavaStackTraceElement> getJavaStackTraceElement() {
        return Optional.ofNullable(this.javaStackTraceElement);
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceReference that = (SourceReference)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.javaMethod, that.javaMethod) && Objects.equals(this.javaStackTraceElement, that.javaStackTraceElement) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.javaMethod, this.javaStackTraceElement, this.location);
    }

    public String toString() {
        return "SourceReference{uri=" + this.uri + ", javaMethod=" + String.valueOf(this.javaMethod) + ", javaStackTraceElement=" + String.valueOf(this.javaStackTraceElement) + ", location=" + String.valueOf(this.location) + "}";
    }
}

