/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import io.cucumber.teamcityformatter.TeamCityCommandWriter;
import io.cucumber.teamcityformatter.TeamCityWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class MessagesToTeamCityWriter
implements AutoCloseable {
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).feature(Repository.RepositoryFeature.INCLUDE_STEP_DEFINITIONS, true).feature(Repository.RepositoryFeature.INCLUDE_HOOKS, true).feature(Repository.RepositoryFeature.INCLUDE_SUGGESTIONS, true).build();
    private final Set<TeamCityFeature> features;
    private final TeamCityWriter writer;
    private boolean streamClosed = false;

    private MessagesToTeamCityWriter(OutputStream out, Set<TeamCityFeature> features) {
        this.writer = new TeamCityWriter(new TeamCityCommandWriter(out), new Query(this.repository));
        this.features = features;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.repository.update(envelope);
        if (this.features.contains((Object)TeamCityFeature.PRINT_TEST_CASES_AFTER_TEST_RUN)) {
            this.writer.printTestCasesAfterTestRun(envelope);
        } else {
            this.writer.printTestCasesRealTime(envelope);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            this.writer.close();
        }
        finally {
            this.streamClosed = true;
        }
    }

    public static final class Builder {
        private final EnumSet<TeamCityFeature> features = EnumSet.noneOf(TeamCityFeature.class);

        private Builder() {
        }

        public Builder feature(TeamCityFeature feature, boolean enabled) {
            if (enabled) {
                this.features.add(feature);
            } else {
                this.features.remove((Object)feature);
            }
            return this;
        }

        public MessagesToTeamCityWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            EnumSet<TeamCityFeature> features = EnumSet.copyOf(this.features);
            return new MessagesToTeamCityWriter(out, features);
        }
    }

    public static enum TeamCityFeature {
        PRINT_TEST_CASES_AFTER_TEST_RUN;

    }
}

