/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class TeamCityCommandWriter
implements AutoCloseable {
    private final PrintWriter out;

    TeamCityCommandWriter(OutputStream out) {
        this.out = TeamCityCommandWriter.createPrintWriter(out);
    }

    private static PrintWriter createPrintWriter(OutputStream out) {
        return new PrintWriter((Writer)new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8), true);
    }

    void print(String command, Object ... args) {
        this.out.println(this.formatCommand(command, args));
    }

    private String formatCommand(String command, Object ... parameters) {
        String[] escapedParameters = new String[parameters.length];
        for (int i = 0; i < escapedParameters.length; ++i) {
            escapedParameters[i] = this.escape(parameters[i].toString());
        }
        return String.format(command, escapedParameters);
    }

    private String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("'", "|'").replace("\n", "|n").replace("\r", "|r").replace("[", "|[").replace("]", "|]");
    }

    @Override
    public void close() {
        this.out.close();
    }
}

