package io.fabric8.kubernetes.api.model.scheduling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PriorityClassBuilder extends PriorityClassFluentImpl<PriorityClassBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PriorityClass,PriorityClassBuilder> {

    PriorityClassFluent<?> fluent;
    Boolean validationEnabled;

    public PriorityClassBuilder() {
        this(true);
    }

    public PriorityClassBuilder(Boolean validationEnabled) {
        this(new PriorityClass(), validationEnabled);
    }

    public PriorityClassBuilder(PriorityClassFluent<?> fluent) {
        this(fluent, true);
    }

    public PriorityClassBuilder(PriorityClassFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PriorityClass(), validationEnabled);
    }

    public PriorityClassBuilder(PriorityClassFluent<?> fluent,PriorityClass instance) {
        this(fluent, instance, true);
    }

    public PriorityClassBuilder(PriorityClassFluent<?> fluent,PriorityClass instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withGlobalDefault(instance.getGlobalDefault()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public PriorityClassBuilder(PriorityClass instance) {
        this(instance,true);
    }

    public PriorityClassBuilder(PriorityClass instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDescription(instance.getDescription()); 
        this.withGlobalDefault(instance.getGlobalDefault()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public PriorityClass build() {
        PriorityClass buildable = new PriorityClass(fluent.getApiVersion(),fluent.getDescription(),fluent.getGlobalDefault(),fluent.getKind(),fluent.getMetadata(),fluent.getPreemptionPolicy(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityClassBuilder that = (PriorityClassBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
