/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.BaseConfiguration;
import io.fluentlenium.configuration.CapabilitiesFactory;
import io.fluentlenium.configuration.CapabilitiesRegistry;
import io.fluentlenium.configuration.ConfigurationDefaults;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationFactory;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.CustomProperty;
import io.fluentlenium.configuration.DefaultConfigurationFactory;
import io.fluentlenium.configuration.FluentConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AnnotationConfiguration
extends BaseConfiguration
implements ConfigurationProperties {
    private final FluentConfiguration configuration;
    private final Map<String, String> customProperties = new HashMap<String, String>();
    private final Json jsonConverter = new Json();

    public AnnotationConfiguration(Class<?> containerClass) {
        this(containerClass == null ? null : containerClass.getAnnotation(FluentConfiguration.class));
    }

    public AnnotationConfiguration(FluentConfiguration configuration) {
        this.configuration = configuration;
        Optional.ofNullable(this.configuration).map(FluentConfiguration::custom).ifPresent(custom -> {
            for (CustomProperty customProperty : custom) {
                this.customProperties.put(customProperty.name(), customProperty.value());
            }
        });
    }

    private String getStringValue(String property) {
        return StringUtils.isEmpty((CharSequence)property) ? null : property;
    }

    private <T extends ConfigurationFactory> Class<T> getConfigurationFactoryClassValue(Class<T> configurationFactoryClass) {
        return configurationFactoryClass == DefaultConfigurationFactory.class ? null : configurationFactoryClass;
    }

    private Class<? extends ConfigurationProperties> getConfigurationDefaultsClassValue(Class<? extends ConfigurationProperties> configurationDefaultsClass) {
        return configurationDefaultsClass == ConfigurationDefaults.class ? null : configurationDefaultsClass;
    }

    private Capabilities getCapabilitiesValue(String property) {
        Capabilities capabilities = null;
        if (!StringUtils.isEmpty((CharSequence)property)) {
            try {
                URL url = new URL(property);
                try (InputStream stream = url.openStream();){
                    property = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Can't read Capabilities defined at " + String.valueOf(url), e);
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            String prop = property;
            capabilities = Optional.ofNullable(this.createNewCapabilitiesFromRegistry(property)).orElseGet(() -> this.convertJsonPropertyToCapabilities(prop));
        }
        return capabilities;
    }

    private Capabilities createNewCapabilitiesFromRegistry(String property) {
        CapabilitiesFactory factory = CapabilitiesRegistry.INSTANCE.get(property);
        if (factory != null) {
            return factory.newCapabilities(this.getGlobalConfiguration());
        }
        return null;
    }

    private Capabilities convertJsonPropertyToCapabilities(String property) {
        try {
            return (Capabilities)this.jsonConverter.toType(property, DesiredCapabilities.class);
        }
        catch (JsonException e) {
            throw new ConfigurationException("Can't convert JSON Capabilities to Object.", e);
        }
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        return this.getConfig(() -> this.getConfigurationDefaultsClassValue(this.configuration.configurationDefaults()));
    }

    private Long getLongValue(Long property) {
        return property < 0L ? null : property;
    }

    private ConfigurationProperties.TriggerMode getTriggerModeValue(ConfigurationProperties.TriggerMode triggerMode) {
        return triggerMode == ConfigurationProperties.TriggerMode.DEFAULT ? null : triggerMode;
    }

    private ConfigurationProperties.DriverLifecycle getDriverLifecycleValue(ConfigurationProperties.DriverLifecycle driverLifecycle) {
        return driverLifecycle == ConfigurationProperties.DriverLifecycle.DEFAULT ? null : driverLifecycle;
    }

    @Override
    public String getWebDriver() {
        return this.getConfig(() -> this.getStringValue(this.configuration.webDriver()));
    }

    @Override
    public String getRemoteUrl() {
        return this.getConfig(() -> this.getStringValue(this.configuration.remoteUrl()));
    }

    @Override
    public Capabilities getCapabilities() {
        return this.getConfig(() -> this.getCapabilitiesValue(this.configuration.capabilities()));
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        return this.getConfig(() -> this.getConfigurationFactoryClassValue(this.configuration.configurationFactory()));
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        return this.getConfig(() -> this.getDriverLifecycleValue(this.configuration.driverLifecycle()));
    }

    @Override
    public Long getBrowserTimeout() {
        return this.getConfig(() -> this.configuration.browserTimeout());
    }

    @Override
    public Integer getBrowserTimeoutRetries() {
        return this.getConfig(() -> this.configuration.browserTimeoutRetries());
    }

    @Override
    public Boolean getDeleteCookies() {
        return this.getConfig(() -> this.configuration.deleteCookies().asBoolean());
    }

    @Override
    public String getBaseUrl() {
        return this.getConfig(() -> this.getStringValue(this.configuration.baseUrl()));
    }

    @Override
    public Long getPageLoadTimeout() {
        return this.getConfig(() -> this.getLongValue(this.configuration.pageLoadTimeout()));
    }

    @Override
    public Long getImplicitlyWait() {
        return this.getConfig(() -> this.getLongValue(this.configuration.implicitlyWait()));
    }

    @Override
    public Long getScriptTimeout() {
        return this.getConfig(() -> this.getLongValue(this.configuration.scriptTimeout()));
    }

    @Override
    public Long getAwaitAtMost() {
        return this.getConfig(() -> this.getLongValue(this.configuration.awaitAtMost()));
    }

    @Override
    public Long getAwaitPollingEvery() {
        return this.getConfig(() -> this.getLongValue(this.configuration.awaitPollingEvery()));
    }

    @Override
    public Boolean getEventsEnabled() {
        return this.getConfig(() -> this.configuration.eventsEnabled().asBoolean());
    }

    @Override
    public String getScreenshotPath() {
        return this.getConfig(() -> this.getStringValue(this.configuration.screenshotPath()));
    }

    @Override
    public String getHtmlDumpPath() {
        return this.getConfig(() -> this.getStringValue(this.configuration.htmlDumpPath()));
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        return this.getConfig(() -> this.getTriggerModeValue(this.configuration.screenshotMode()));
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        return this.getConfig(() -> this.getTriggerModeValue(this.configuration.htmlDumpMode()));
    }

    @Override
    public String getCustomProperty(String propertyName) {
        return this.customProperties.get(propertyName);
    }

    private <T> T getConfig(Supplier<T> configSupplier) {
        return this.configuration == null ? null : (T)configSupplier.get();
    }
}

