/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.events;

import io.fluentlenium.core.events.AnnotationAlertListener;
import io.fluentlenium.core.events.AnnotationElementListener;
import io.fluentlenium.core.events.AnnotationFindByListener;
import io.fluentlenium.core.events.AnnotationGetScreenshotAsListener;
import io.fluentlenium.core.events.AnnotationNavigateAllListener;
import io.fluentlenium.core.events.AnnotationNavigateListener;
import io.fluentlenium.core.events.AnnotationNavigateToListener;
import io.fluentlenium.core.events.AnnotationScriptListener;
import io.fluentlenium.core.events.AnnotationSwitchToWindowListener;
import io.fluentlenium.core.events.EventsRegistry;
import io.fluentlenium.core.events.ListenerContext;
import io.fluentlenium.core.events.annotations.AfterAlertAccept;
import io.fluentlenium.core.events.annotations.AfterAlertDismiss;
import io.fluentlenium.core.events.annotations.AfterChangeValueOf;
import io.fluentlenium.core.events.annotations.AfterClickOn;
import io.fluentlenium.core.events.annotations.AfterFindBy;
import io.fluentlenium.core.events.annotations.AfterGetScreenshotAs;
import io.fluentlenium.core.events.annotations.AfterGetText;
import io.fluentlenium.core.events.annotations.AfterNavigate;
import io.fluentlenium.core.events.annotations.AfterNavigateBack;
import io.fluentlenium.core.events.annotations.AfterNavigateForward;
import io.fluentlenium.core.events.annotations.AfterNavigateRefresh;
import io.fluentlenium.core.events.annotations.AfterNavigateTo;
import io.fluentlenium.core.events.annotations.AfterScript;
import io.fluentlenium.core.events.annotations.AfterSwitchToWindow;
import io.fluentlenium.core.events.annotations.BeforeAlertAccept;
import io.fluentlenium.core.events.annotations.BeforeAlertDismiss;
import io.fluentlenium.core.events.annotations.BeforeChangeValueOf;
import io.fluentlenium.core.events.annotations.BeforeClickOn;
import io.fluentlenium.core.events.annotations.BeforeFindBy;
import io.fluentlenium.core.events.annotations.BeforeGetScreenshotAs;
import io.fluentlenium.core.events.annotations.BeforeGetText;
import io.fluentlenium.core.events.annotations.BeforeNavigate;
import io.fluentlenium.core.events.annotations.BeforeNavigateBack;
import io.fluentlenium.core.events.annotations.BeforeNavigateForward;
import io.fluentlenium.core.events.annotations.BeforeNavigateRefresh;
import io.fluentlenium.core.events.annotations.BeforeNavigateTo;
import io.fluentlenium.core.events.annotations.BeforeScript;
import io.fluentlenium.core.events.annotations.BeforeSwitchToWindow;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.WebElement;

public class ContainerAnnotationsEventsRegistry {
    private static final Map<Class<? extends Annotation>, PriorityRetriever> ANNOTATION_TO_PRIORITY;
    private static final Map<Class<? extends Annotation>, ListenerRegister> ANNOTATION_TO_REGISTER;
    private final EventsRegistry registry;
    private final Object container;
    private int listenerCount;

    public ContainerAnnotationsEventsRegistry(EventsRegistry registry, Object container) {
        this(registry, container, null);
    }

    public ContainerAnnotationsEventsRegistry(EventsRegistry registry, Object container, WebElement targetElement) {
        this.registry = registry;
        this.container = container;
        this.setupListenersInEventsRegistry(targetElement);
    }

    private void setupListenersInEventsRegistry(WebElement targetElement) {
        this.listenerCount = 0;
        for (Class<?> current = this.container.getClass(); current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                ListenerContext listenerContext = new ListenerContext(method, this.container, targetElement);
                ANNOTATION_TO_REGISTER.forEach((annotation, listenerRegister) -> {
                    if (method.getAnnotation(annotation) != null) {
                        listenerContext.setAnnotationName(annotation.getSimpleName());
                        listenerContext.setPriority((Integer)ANNOTATION_TO_PRIORITY.get(annotation).apply(method));
                        listenerRegister.apply(this.registry, listenerContext);
                        ++this.listenerCount;
                    }
                });
            }
        }
        this.registry.sortListeners();
    }

    public int getListenerCount() {
        return this.listenerCount;
    }

    public void close() {
        this.registry.unregisterContainer(this.container);
    }

    static {
        HashMap<Class, PriorityRetriever> priorities = new HashMap<Class, PriorityRetriever>();
        HashMap<Class, ListenerRegister> registers = new HashMap<Class, ListenerRegister>();
        priorities.put(BeforeClickOn.class, method -> method.getAnnotation(BeforeClickOn.class).value());
        priorities.put(AfterClickOn.class, method -> method.getAnnotation(AfterClickOn.class).value());
        priorities.put(BeforeGetText.class, method -> method.getAnnotation(BeforeGetText.class).value());
        priorities.put(AfterGetText.class, method -> method.getAnnotation(AfterGetText.class).value());
        priorities.put(BeforeChangeValueOf.class, method -> method.getAnnotation(BeforeChangeValueOf.class).value());
        priorities.put(AfterChangeValueOf.class, method -> method.getAnnotation(AfterChangeValueOf.class).value());
        priorities.put(BeforeFindBy.class, method -> method.getAnnotation(BeforeFindBy.class).value());
        priorities.put(AfterFindBy.class, method -> method.getAnnotation(AfterFindBy.class).value());
        priorities.put(BeforeNavigateBack.class, method -> method.getAnnotation(BeforeNavigateBack.class).value());
        priorities.put(AfterNavigateBack.class, method -> method.getAnnotation(AfterNavigateBack.class).value());
        priorities.put(BeforeNavigateForward.class, method -> method.getAnnotation(BeforeNavigateForward.class).value());
        priorities.put(AfterNavigateForward.class, method -> method.getAnnotation(AfterNavigateForward.class).value());
        priorities.put(BeforeNavigateTo.class, method -> method.getAnnotation(BeforeNavigateTo.class).value());
        priorities.put(AfterNavigateTo.class, method -> method.getAnnotation(AfterNavigateTo.class).value());
        priorities.put(BeforeNavigate.class, method -> method.getAnnotation(BeforeNavigate.class).value());
        priorities.put(AfterNavigate.class, method -> method.getAnnotation(AfterNavigate.class).value());
        priorities.put(BeforeNavigateRefresh.class, method -> method.getAnnotation(BeforeNavigateRefresh.class).value());
        priorities.put(AfterNavigateRefresh.class, method -> method.getAnnotation(AfterNavigateRefresh.class).value());
        priorities.put(BeforeScript.class, method -> method.getAnnotation(BeforeScript.class).value());
        priorities.put(AfterScript.class, method -> method.getAnnotation(AfterScript.class).value());
        priorities.put(BeforeAlertAccept.class, method -> method.getAnnotation(BeforeAlertAccept.class).value());
        priorities.put(AfterAlertAccept.class, method -> method.getAnnotation(AfterAlertAccept.class).value());
        priorities.put(BeforeAlertDismiss.class, method -> method.getAnnotation(BeforeAlertDismiss.class).value());
        priorities.put(AfterAlertDismiss.class, method -> method.getAnnotation(AfterAlertDismiss.class).value());
        priorities.put(BeforeSwitchToWindow.class, method -> method.getAnnotation(BeforeSwitchToWindow.class).value());
        priorities.put(AfterSwitchToWindow.class, method -> method.getAnnotation(AfterSwitchToWindow.class).value());
        priorities.put(BeforeGetScreenshotAs.class, method -> method.getAnnotation(BeforeGetScreenshotAs.class).value());
        priorities.put(AfterGetScreenshotAs.class, method -> method.getAnnotation(AfterGetScreenshotAs.class).value());
        registers.put(BeforeClickOn.class, (reg, ctx) -> reg.beforeClickOn(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(AfterClickOn.class, (reg, ctx) -> reg.afterClickOn(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(BeforeGetText.class, (reg, ctx) -> reg.beforeGetText(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(AfterGetText.class, (reg, ctx) -> reg.afterGetText(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(BeforeChangeValueOf.class, (reg, ctx) -> reg.beforeChangeValueOf(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(AfterChangeValueOf.class, (reg, ctx) -> reg.afterChangeValueOf(new AnnotationElementListener((ListenerContext)ctx)));
        registers.put(BeforeFindBy.class, (reg, ctx) -> reg.beforeFindBy(new AnnotationFindByListener((ListenerContext)ctx)));
        registers.put(AfterFindBy.class, (reg, ctx) -> reg.afterFindBy(new AnnotationFindByListener((ListenerContext)ctx)));
        registers.put(BeforeNavigateBack.class, (reg, ctx) -> reg.beforeNavigateBack(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(AfterNavigateBack.class, (reg, ctx) -> reg.afterNavigateBack(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(BeforeNavigateForward.class, (reg, ctx) -> reg.beforeNavigateForward(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(AfterNavigateForward.class, (reg, ctx) -> reg.afterNavigateForward(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(BeforeNavigateTo.class, (reg, ctx) -> reg.beforeNavigateTo(new AnnotationNavigateToListener((ListenerContext)ctx)));
        registers.put(AfterNavigateTo.class, (reg, ctx) -> reg.afterNavigateTo(new AnnotationNavigateToListener((ListenerContext)ctx)));
        registers.put(BeforeNavigate.class, (reg, ctx) -> reg.beforeNavigate(new AnnotationNavigateAllListener((ListenerContext)ctx)));
        registers.put(AfterNavigate.class, (reg, ctx) -> reg.afterNavigate(new AnnotationNavigateAllListener((ListenerContext)ctx)));
        registers.put(BeforeNavigateRefresh.class, (reg, ctx) -> reg.beforeNavigateRefresh(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(AfterNavigateRefresh.class, (reg, ctx) -> reg.afterNavigateRefresh(new AnnotationNavigateListener((ListenerContext)ctx)));
        registers.put(BeforeScript.class, (reg, ctx) -> reg.beforeScript(new AnnotationScriptListener((ListenerContext)ctx)));
        registers.put(AfterScript.class, (reg, ctx) -> reg.afterScript(new AnnotationScriptListener((ListenerContext)ctx)));
        registers.put(BeforeAlertAccept.class, (reg, ctx) -> reg.beforeAlertAccept(new AnnotationAlertListener((ListenerContext)ctx)));
        registers.put(AfterAlertAccept.class, (reg, ctx) -> reg.afterAlertAccept(new AnnotationAlertListener((ListenerContext)ctx)));
        registers.put(BeforeAlertDismiss.class, (reg, ctx) -> reg.beforeAlertDismiss(new AnnotationAlertListener((ListenerContext)ctx)));
        registers.put(AfterAlertDismiss.class, (reg, ctx) -> reg.afterAlertDismiss(new AnnotationAlertListener((ListenerContext)ctx)));
        registers.put(BeforeSwitchToWindow.class, (reg, ctx) -> reg.beforeSwitchToWindow(new AnnotationSwitchToWindowListener((ListenerContext)ctx)));
        registers.put(AfterSwitchToWindow.class, (reg, ctx) -> reg.afterSwitchToWindow(new AnnotationSwitchToWindowListener((ListenerContext)ctx)));
        registers.put(BeforeGetScreenshotAs.class, (reg, ctx) -> reg.beforeGetScreenshotAs(new AnnotationGetScreenshotAsListener((ListenerContext)ctx)));
        registers.put(AfterGetScreenshotAs.class, (reg, ctx) -> reg.afterGetScreenshotAs(new AnnotationGetScreenshotAsListener((ListenerContext)ctx)));
        ANNOTATION_TO_PRIORITY = Collections.unmodifiableMap(priorities);
        ANNOTATION_TO_REGISTER = Collections.unmodifiableMap(registers);
    }

    private static interface PriorityRetriever
    extends Function<Method, Integer> {
    }

    private static interface ListenerRegister
    extends BiFunction<EventsRegistry, ListenerContext, EventsRegistry> {
    }
}

