/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.inject;

import com.google.common.collect.ImmutableSet;
import io.fluentlenium.core.FluentPage;
import io.fluentlenium.core.annotation.Unshadow;
import io.fluentlenium.core.domain.FluentWebElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unshadower {
    private static final Logger LOGGER = LoggerFactory.getLogger(Unshadower.class);
    private final WebDriver webDriver;
    private final FluentPage page;
    private final FluentWebElement fluentWebElement;

    public Unshadower(WebDriver webDriver, FluentPage page) {
        this.webDriver = webDriver;
        this.page = page;
        this.fluentWebElement = null;
    }

    public Unshadower(WebDriver webDriver, FluentWebElement fluentWebElement) {
        this.webDriver = webDriver;
        this.page = null;
        this.fluentWebElement = fluentWebElement;
    }

    public Object getContext() {
        return this.page != null ? this.page : this.fluentWebElement;
    }

    public void unshadowAllAnnotatedFields() {
        Arrays.stream(this.getContext().getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(Unshadow.class)).forEach(this::unshadowField);
    }

    private void unshadowField(Field field) {
        String[] cssSelectors = field.getAnnotation(Unshadow.class).css();
        List<List<WebElement>> deepestShadowRoots = this.extractShadowRoots(cssSelectors);
        this.setValue(field, this.convertToFluentWebElementList(deepestShadowRoots.get(deepestShadowRoots.size() - 1)));
    }

    private List<FluentWebElement> convertToFluentWebElementList(List<WebElement> lastShadowRoots) {
        if (this.getContext() instanceof FluentPage) {
            return lastShadowRoots.stream().map(element -> new FluentWebElement((WebElement)element, this.page.getFluentControl(), this.page.getFluentControl())).collect(Collectors.toList());
        }
        return lastShadowRoots.stream().map(element -> new FluentWebElement((WebElement)element, this.fluentWebElement.getFluentControl(), this.fluentWebElement.getFluentControl())).collect(Collectors.toList());
    }

    private List<List<WebElement>> extractShadowRoots(String[] cssSelectors) {
        WebElement domRoot = this.webDriver.findElement(By.xpath((String)"/*"));
        List<List<WebElement>> currentShadowRootsInContext = Collections.singletonList(Collections.singletonList(domRoot));
        if (cssSelectors.length == 1) {
            currentShadowRootsInContext = this.extractElementsFromShadowRoot(currentShadowRootsInContext, cssSelectors[0], By.xpath((String)"/*"));
        } else {
            for (int i = 0; cssSelectors.length - 1 > i; ++i) {
                currentShadowRootsInContext = this.extractElementsFromShadowRoot(currentShadowRootsInContext, cssSelectors[i], By.cssSelector((String)cssSelectors[i + 1]));
            }
        }
        return currentShadowRootsInContext;
    }

    private List<List<WebElement>> extractElementsFromShadowRoot(List<List<WebElement>> previousNodes, String cssSelector, By selector) {
        return previousNodes.stream().flatMap(Collection::stream).flatMap(webElement -> webElement.findElements(By.cssSelector((String)cssSelector)).stream()).map(element -> this.unshadow((WebElement)element, selector)).collect(Collectors.toList());
    }

    private List<WebElement> unshadow(WebElement element, By selector) {
        JavascriptExecutor executor = (JavascriptExecutor)this.webDriver;
        SearchContext shadowRoot = (SearchContext)executor.executeScript("return arguments[0].shadowRoot", new Object[]{element});
        return shadowRoot.findElements(selector);
    }

    private void setValue(Field field, List<FluentWebElement> elements) {
        if (List.class.isAssignableFrom(field.getType())) {
            this.setValueToField(field, elements);
        } else if (Set.class.isAssignableFrom(field.getType())) {
            this.setValueToField(field, ImmutableSet.copyOf(elements));
        } else if (!elements.isEmpty()) {
            this.setValueToField(field, elements.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueToField(Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            if (this.getContext() instanceof FluentPage) {
                field.set(this.page, value);
            } else {
                field.set(this.fluentWebElement, value);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Couldn't set value to field", (Throwable)e);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }
}

