/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.utils.chromium;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.fluentlenium.utils.chromium.ChromiumApiNotSupportedException;
import io.fluentlenium.utils.chromium.Commands;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromiumApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromiumApi.class);
    private final RemoteWebDriver remoteWebDriver;
    private static final List<String> SUPPORTED_BROWSERS = ImmutableList.of((Object)"chrome", (Object)"msedge");

    public ChromiumApi(RemoteWebDriver remoteWebDriver) {
        Objects.requireNonNull(remoteWebDriver, "WebDriver instance must not be null");
        String browserName = remoteWebDriver.getCapabilities().getBrowserName();
        if (!SUPPORTED_BROWSERS.contains(browserName)) {
            throw new ChromiumApiNotSupportedException("API supported only by Chrome and Edge");
        }
        this.remoteWebDriver = remoteWebDriver;
        this.defineCommandViaReflection();
    }

    public void sendCommand(String methodName, Map<String, ?> params) {
        Command command = this.createCommand(methodName, params, Commands.SEND_COMMAND.getCmdName());
        CommandExecutor cmdExecutor = this.remoteWebDriver.getCommandExecutor();
        this.executeCommand(cmdExecutor, command, methodName);
    }

    public Response sendCommandAndGetResponse(String methodName, Map<String, ?> params) {
        Command command = this.createCommand(methodName, params, Commands.SEND_COMMAND_AND_GET_RESULT.getCmdName());
        CommandExecutor cmdExecutor = this.remoteWebDriver.getCommandExecutor();
        return this.executeCommand(cmdExecutor, command, methodName);
    }

    private void defineCommandViaReflection() {
        try {
            Method defineCmd = HttpCommandExecutor.class.getDeclaredMethod("defineCommand", String.class, CommandInfo.class);
            defineCmd.setAccessible(true);
            defineCmd.invoke((Object)this.remoteWebDriver.getCommandExecutor(), Commands.SEND_COMMAND_AND_GET_RESULT.getCmdName(), new CommandInfo(Commands.SEND_COMMAND_AND_GET_RESULT.getCmdInfo(), HttpMethod.POST));
            defineCmd.invoke((Object)this.remoteWebDriver.getCommandExecutor(), Commands.SEND_COMMAND.getCmdName(), new CommandInfo(Commands.SEND_COMMAND.getCmdInfo(), HttpMethod.POST));
        }
        catch (Exception e) {
            LOGGER.error("Failed to define command via reflection");
        }
    }

    private Response executeCommand(CommandExecutor cmdExecutor, Command command, String methodName) {
        try {
            Response response = cmdExecutor.execute(command);
            LOGGER.info("Command \"{}\" executed with {} state", (Object)methodName, (Object)response.getState());
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute {} via Chrome API", (Object)command.getName());
            return null;
        }
    }

    private Command createCommand(String methodName, Map<String, ?> commandParams, String endpointName) {
        SessionId sessionId = this.remoteWebDriver.getSessionId();
        ImmutableMap param = ImmutableMap.of((Object)"cmd", (Object)methodName, (Object)"params", commandParams);
        return new Command(sessionId, endpointName, (Map)param);
    }
}

