/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.actor;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.actor.Actor;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.actor.AtomicRunnableActorRef$;
import io.gatling.core.actor.Cancellable;
import io.gatling.core.actor.package;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]t!B\f\u0019\u0011\u0013\tc!B\u0012\u0019\u0011\u0013!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%IA\f\u0005\u0007e\u0005\u0001\u000b\u0011B\u0018\u0007\t\rBba\r\u0005\t3\u0015\u0011\t\u0011)A\u0005+\"A\u0001,\u0002B\u0001B\u0003%\u0011\fC\u0003,\u000b\u0011\u0005A\fC\u0004a\u000b\t\u0007I\u0011B1\t\r1,\u0001\u0015!\u0003c\u0011\u001diWA1A\u0005\n\u0005DaA\\\u0003!\u0002\u0013\u0011\u0007bB8\u0006\u0005\u0004%I\u0001\u001d\u0005\b\u0003\u000b)\u0001\u0015!\u0003r\u0011%\t9!\u0002a\u0001\n\u0013\tI\u0001C\u0005\u0002\u001a\u0015\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011qE\u0003!B\u0013\tY\u0001C\u0004\u0002*\u0015!\t%a\u000b\t\u000f\u0005ER\u0001\"\u0011\u00024!9\u0011qK\u0003\u0005B\u0005e\u0003bBA9\u000b\u0011%\u00111\u000f\u0005\b\u0003k*A\u0011IA:\u0003Y\tEo\\7jGJ+hN\\1cY\u0016\f5\r^8s%\u00164'BA\r\u001b\u0003\u0015\t7\r^8s\u0015\tYB$\u0001\u0003d_J,'BA\u000f\u001f\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aH\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002#\u00035\t\u0001D\u0001\fBi>l\u0017n\u0019*v]:\f'\r\\3BGR|'OU3g'\t\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\n\u0011#T1jY\n|\u0007\u0010\u0012:bS:d\u0015.\\5u+\u0005y\u0003C\u0001\u00141\u0013\t\ttEA\u0002J]R\f!#T1jY\n|\u0007\u0010\u0012:bS:d\u0015.\\5uAU\u0011AGO\n\u0006\u000b\u0015*4i\u0013\t\u0004EYB\u0014BA\u001c\u0019\u0005!\t5\r^8s%\u00164\u0007CA\u001d;\u0019\u0001!QaO\u0003C\u0002q\u0012q!T3tg\u0006<W-\u0005\u0002>\u0001B\u0011aEP\u0005\u0003\u007f\u001d\u0012qAT8uQ&tw\r\u0005\u0002'\u0003&\u0011!i\n\u0002\u0004\u0003:L\bC\u0001#J\u001b\u0005)%B\u0001$H\u0003\u0011a\u0017M\\4\u000b\u0003!\u000bAA[1wC&\u0011!*\u0012\u0002\t%Vtg.\u00192mKB\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003!F\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002%\u0006\u00191m\\7\n\u0005Qk%!D*ue&\u001cG\u000fT8hO&tw\rE\u0002#-bJ!a\u0016\r\u0003\u000b\u0005\u001bGo\u001c:\u0002\rML8\u000f^3n!\t\u0011#,\u0003\u0002\\1\tY\u0011i\u0019;peNK8\u000f^3n)\rifl\u0018\t\u0004E\u0015A\u0004\"B\r\t\u0001\u0004)\u0006\"\u0002-\t\u0001\u0004I\u0016AA8o+\u0005\u0011\u0007CA2k\u001b\u0005!'BA3g\u0003\u0019\tGo\\7jG*\u0011q\r[\u0001\u000bG>t7-\u001e:sK:$(BA5H\u0003\u0011)H/\u001b7\n\u0005-$'!D!u_6L7MQ8pY\u0016\fg.A\u0002p]\u0002\n1\u0001Z5f\u0003\u0011!\u0017.\u001a\u0011\u0002\t5\u0014w\u000e_\u000b\u0002cB!!/!\u00019\u001b\u0005\u0019(B\u0001;v\u0003\u0019\tX/Z;fg*\u0011ao^\u0001\bU\u000e$xn\u001c7t\u0015\tA\u00180A\u0002pe\u001eT!A_>\u0002\rMD\u0017\rZ3e\u0015\taX0\u0001\u0005j]R,'O\\1m\u0015\tIgP\u0003\u0002\u0000=\u0005)a.\u001a;us&\u0019\u00111A:\u0003'5+7o]1hKB\u000b7o]5oOF+X-^3\u0002\u000b5\u0014w\u000e\u001f\u0011\u0002\u0011\t,\u0007.\u0019<j_J,\"!a\u0003\u0011\u000b\u00055\u00111\u0003\u001d\u000f\u0007\t\ny!C\u0002\u0002\u0012a\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!\u0001\u0003\"fQ\u00064\u0018n\u001c:\u000b\u0007\u0005E\u0001$\u0001\u0007cK\"\fg/[8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005\r\u0002c\u0001\u0014\u0002 %\u0019\u0011\u0011E\u0014\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003K\u0001\u0012\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00132\u0003%\u0011W\r[1wS>\u0014\b%A\u0003%E\u0006tw\r\u0006\u0003\u0002\u001e\u00055\u0002BBA\u0018%\u0001\u0007\u0001(A\u0002ng\u001e\fAB]3qYf\u0004&o\\7jg\u0016,B!!\u000e\u0002DQ!\u0011qGA$!\u0019\tI$!\u0010\u0002B5\u0011\u00111\b\u0006\u0003O\u001eJA!a\u0010\u0002<\t9\u0001K]8nSN,\u0007cA\u001d\u0002D\u00111\u0011QI\nC\u0002q\u0012QAU3qYfDq!!\u0013\u0014\u0001\u0004\tY%A\u0004uS6,w.\u001e;\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fRA!!\u0015\u0002<\u0005AA-\u001e:bi&|g.\u0003\u0003\u0002V\u0005=#A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0005]\u0006lW-\u0006\u0002\u0002\\A!\u0011QLA6\u001d\u0011\ty&a\u001a\u0011\u0007\u0005\u0005t%\u0004\u0002\u0002d)\u0019\u0011Q\r\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\tIgJ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%t%A\u0003bgft7\r\u0006\u0002\u0002\u001e\u0005\u0019!/\u001e8")
public final class AtomicRunnableActorRef<Message>
implements ActorRef<Message>,
Runnable,
StrictLogging {
    private final Actor<Message> actor;
    private final ActorSystem system;
    private final AtomicBoolean on;
    private final AtomicBoolean die;
    private final MessagePassingQueue<Message> mbox;
    private package.Behavior<Message> behavior;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private AtomicBoolean on() {
        return this.on;
    }

    private AtomicBoolean die() {
        return this.die;
    }

    private MessagePassingQueue<Message> mbox() {
        return this.mbox;
    }

    private package.Behavior<Message> behavior() {
        return this.behavior;
    }

    private void behavior_$eq(package.Behavior<Message> x$1) {
        this.behavior = x$1;
    }

    @Override
    public void $bang(Message msg) {
        this.mbox().offer(msg);
        this.async();
    }

    @Override
    public <Reply> Promise<Reply> replyPromise(FiniteDuration timeout) {
        Promise result = Promise$.MODULE$.apply();
        Cancellable timeoutCancellable = this.system.scheduler().scheduleOnce(timeout, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean timeoutTriggered = result.tryFailure((Throwable)new TimeoutException());
            if (timeoutTriggered) {
                this.die().set(true);
                this.async();
                return;
            }
        });
        result.future().onComplete((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)timeoutCancellable.cancel()), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
        return result;
    }

    @Override
    public String name() {
        return this.actor.name();
    }

    private void async() {
        if ((!this.mbox().isEmpty() || this.die().get()) && this.on().compareAndSet(false, true)) {
            try {
                this.system.executionContext().execute((Runnable)this);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Actor " + this.actor.name() + " crashed", throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.on().set(false);
                    throw throwable2;
                }
                throw throwable;
            }
            return;
        }
    }

    @Override
    public void run() {
        try {
            if (this.on().get()) {
                if (this.die().compareAndSet(true, false)) {
                    this.behavior_$eq((package.Behavior)this.actor.die().apply(this.behavior()));
                } else {
                    this.mbox().drain(m -> {
                        try {
                            this.behavior_$eq((package.Behavior)((Function1)this.behavior().apply(m)).apply(this.behavior()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (NonFatal$.MODULE$.apply(throwable2)) {
                                if (this.logger().underlying().isErrorEnabled()) {
                                    this.logger().underlying().error("Actor " + $this.actor.name() + " crashed when processing message '" + m + "'", throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }, AtomicRunnableActorRef$.MODULE$.io$gatling$core$actor$AtomicRunnableActorRef$$MailboxDrainLimit());
                }
            }
        }
        finally {
            this.on().set(false);
            this.async();
        }
    }

    public AtomicRunnableActorRef(Actor<Message> actor, ActorSystem system) {
        this.actor = actor;
        this.system = system;
        StrictLogging.$init$((StrictLogging)this);
        this.on = new AtomicBoolean();
        this.die = new AtomicBoolean();
        this.mbox = (MessagePassingQueue)PlatformDependent.newMpscQueue();
        actor.initRefs(system.scheduler(), this);
        this.behavior = actor.init();
        Statics.releaseFence();
    }
}

