/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.actor;

import io.gatling.core.actor.Cancellable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00014A\u0001C\u0005\u0003%!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u0003F\u0001\u0011\u0005a\tC\u0003F\u0001\u0011\u00051\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003_\u0001\u0011\u0005sLA\u0005TG\",G-\u001e7fe*\u0011!bC\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u00195\tAaY8sK*\u0011abD\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0001\u0012AA5p\u0007\u0001\u00192\u0001A\n\u001c!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003mC:<'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u001d\u0013\tiRCA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002%/\u0005!Q\u000f^5m\u0013\t1\u0013E\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\n\u0011\u0015q\"\u00011\u0001 \u00031\u00198\r[3ek2,wJ\\2f)\tqS\b\u0006\u00020eA\u0011!\u0006M\u0005\u0003c%\u00111bQ1oG\u0016dG.\u00192mK\"11g\u0001CA\u0002Q\nA\u0001^1tWB\u0019Q\u0007\u000f\u001e\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003kmJ!\u0001\u0010\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\r\u0001\raP\u0001\tIV\u0014\u0018\r^5p]B\u0011\u0001iQ\u0007\u0002\u0003*\u0011aH\u0011\u0006\u0003EYJ!\u0001R!\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u00192o\u00195fIVdW-\u0011;GSb,GMU1uKR\u0011q)\u0013\u000b\u0003_!Caa\r\u0003\u0005\u0002\u0004!\u0004\"\u0002&\u0005\u0001\u0004y\u0014A\u00029fe&|G\rF\u0002M\u001dB#\"aL'\t\rM*A\u00111\u00015\u0011\u0015yU\u00011\u0001@\u00031Ig.\u001b;jC2$U\r\\1z\u0011\u0015QU\u00011\u0001@\u0003Y\u00198\r[3ek2,w+\u001b;i\r&DX\r\u001a#fY\u0006LHcA*];R\u0011Ak\u0017\u000b\u0003_UCQA\u0016\u0004A\u0004]\u000b!!Z2\u0011\u0005aKV\"\u0001\"\n\u0005i\u0013%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019\u0019d\u0001\"a\u0001i!)qJ\u0002a\u0001\u007f!)!J\u0002a\u0001\u007f\u0005)1\r\\8tKR\t!\b")
public final class Scheduler
implements AutoCloseable {
    private final ScheduledExecutorService scheduler;

    public Cancellable scheduleOnce(FiniteDuration duration, Function0<BoxedUnit> task) {
        ScheduledFuture<?> future = this.scheduler.schedule(() -> task.apply$mcV$sp(), duration.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(true);
    }

    public Cancellable scheduleAtFixedRate(FiniteDuration period, Function0<BoxedUnit> task) {
        return this.scheduleAtFixedRate(period, period, task);
    }

    public Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration period, Function0<BoxedUnit> task) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> task.apply$mcV$sp(), initialDelay.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(true);
    }

    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration period, Function0<BoxedUnit> task, ExecutionContext ec) {
        ScheduledFuture<?> future = this.scheduler.scheduleWithFixedDelay(() -> ec.execute(() -> task.apply$mcV$sp()), initialDelay.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(true);
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
    }

    public Scheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }
}

