/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d!\u0002\u000f\u001e\u0003\u0013A\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005-\")A\f\u0001C\u0001;\"9A\r\u0001a\u0001\n\u0013)\u0007bB5\u0001\u0001\u0004%IA\u001b\u0005\u0007a\u0002\u0001\u000b\u0015\u00024\t\u000fE\u0004\u0001\u0019!C\u0005K\"9!\u000f\u0001a\u0001\n\u0013\u0019\bBB;\u0001A\u0003&a\rC\u0004w\u0001\u0001\u0007I\u0011B<\t\u000fm\u0004\u0001\u0019!C\u0005y\"1a\u0010\u0001Q!\naDaa \u0001\u0005\n\u0005\u0005\u0001bBA\u0002\u0001\u0011E\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001A\u0011CA\u0001\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\u0007\u0001\t#\tY\u0002C\u0004\u00020\u0001!\t\"!\r\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u00111\u000b\u0001\u0007\u0002\u0005U\u0003bBA.\u0001\u0019\u0005\u0011\u0011\u0001\u0005\u0007\u0003;\u0002A\u0011A<\t\r\u0005}\u0003\u0001\"\u0001x\u0011\u001d\t9\u0003\u0001D\u0001\u0003CBa!a\u0019\u0001\r\u00039(\u0001C,pe.dw.\u00193\u000b\u0005yy\u0012AB5oU\u0016\u001cGO\u0003\u0002!C\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005\t\u001a\u0013\u0001B2pe\u0016T!\u0001J\u0013\u0002\u000f\u001d\fG\u000f\\5oO*\ta%\u0001\u0002j_\u000e\u00011c\u0001\u0001*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005Q*\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003Y\n1aY8n\u0013\tA\u0014GA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\tg\u000e,g.\u0019:j_B\u00111(P\u0007\u0002y)\u0011\u0011(I\u0005\u0003}q\u0012\u0001bU2f]\u0006\u0014\u0018n\\\u0001\nkN,'/\u00133HK:\u0004\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\r\u0005$x.\\5d\u0015\t)e)\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tY%I\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fa\"\u001a<f]Rdun\u001c9He>,\b\u000f\u0005\u0002O'6\tqJ\u0003\u0002Q#\u000691\r[1o]\u0016d'B\u0001*&\u0003\u0015qW\r\u001e;z\u0013\t!vJ\u0001\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u0017M$\u0018\r^:F]\u001eLg.\u001a\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0006\nQa\u001d;biNL!a\u0017-\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\u0003\u0017MY2\u0011\u0005}\u0003Q\"A\u000f\t\u000be*\u0001\u0019\u0001\u001e\t\u000b}*\u0001\u0019\u0001!\t\u000b1+\u0001\u0019A'\t\u000bU+\u0001\u0019\u0001,\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$W#\u00014\u0011\u0005):\u0017B\u00015,\u0005\u0011auN\\4\u0002\u001bM\u001c\u0007.\u001a3vY\u0016$w\fJ3r)\tYg\u000e\u0005\u0002+Y&\u0011Qn\u000b\u0002\u0005+:LG\u000fC\u0004p\u000f\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0013'\u0001\u0006tG\",G-\u001e7fI\u0002\nqa\u001d;paB,G-A\u0006ti>\u0004\b/\u001a3`I\u0015\fHCA6u\u0011\u001dy'\"!AA\u0002\u0019\f\u0001b\u001d;paB,G\rI\u0001\rC2d7k\u00195fIVdW\rZ\u000b\u0002qB\u0011!&_\u0005\u0003u.\u0012qAQ8pY\u0016\fg.\u0001\tbY2\u001c6\r[3ek2,Gm\u0018\u0013fcR\u00111. \u0005\b_6\t\t\u00111\u0001y\u00035\tG\u000e\\*dQ\u0016$W\u000f\\3eA\u00059\u0012N\\2sK6,g\u000e^*dQ\u0016$W\u000f\\3e+N,'o\u001d\u000b\u0002W\u0006y1/\u001a;BY2\u001c6\r[3ek2,G-A\u000bj]\u000e\u0014X-\\3oiN#x\u000e\u001d9fIV\u001bXM]:\u0002\u0013M$\u0018M\u001d;Vg\u0016\u0014H#B6\u0002\f\u0005=\u0001BBA\u0007%\u0001\u0007a-\u0001\u0004vg\u0016\u0014\u0018\n\u001a\u0005\b\u0003#\u0011\u0002\u0019AA\n\u0003%)g/\u001a8u\u0019>|\u0007\u000fE\u0002O\u0003+I1!a\u0006P\u0005%)e/\u001a8u\u0019>|\u0007/\u0001\u0006j]*,7\r^+tKJ$2a[A\u000f\u0011\u001d\tyb\u0005a\u0001\u0003C\tQ\u0001Z3mCf\u0004B!a\t\u0002,5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005ekJ\fG/[8o\u0015\t)5&\u0003\u0003\u0002.\u0005\u0015\"A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0013O\u0016$8i\u001c8dkJ\u0014XM\u001c;Vg\u0016\u00148/\u0006\u0002\u00024A\u0019!&!\u000e\n\u0007\u0005]2FA\u0002J]R\fAb]2f]\u0006\u0014\u0018n\u001c(b[\u0016,\"!!\u0010\u0011\t\u0005}\u0012Q\n\b\u0005\u0003\u0003\nI\u0005E\u0002\u0002D-j!!!\u0012\u000b\u0007\u0005\u001ds%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017Z\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005E#AB*ue&twMC\u0002\u0002L-\n1\"\u001b8kK\u000e$()\u0019;dQR\u00191.a\u0016\t\u000f\u0005ec\u00031\u0001\u0002\"\u0005Y!-\u0019;dQ^Kg\u000eZ8x\u0003\u001d)g\u000eZ+tKJ\f1#[:BY2,6/\u001a:t'\u000eDW\rZ;mK\u0012\f\u0011#[:BY2,6/\u001a:t'R|\u0007\u000f]3e+\t\t\t#A\u0004jg\u0016k\u0007\u000f^=")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final EventLoopGroup eventLoopGroup;
    private final StatsEngine statsEngine;
    private long scheduled;
    private long stopped;
    private boolean allScheduled;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(long x$1) {
        this.scheduled = x$1;
    }

    private long stopped() {
        return this.stopped;
    }

    private void stopped_$eq(long x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1L);
    }

    public void setAllScheduled() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Scenario {} has finished injecting", (Object)this.scenario.name());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1L);
    }

    private void startUser(long userId, EventLoop eventLoop) {
        BoxedUnit boxedUnit;
        Session rawSession = Session$.MODULE$.apply(this.scenario.name(), userId, this.scenario.onExit(), eventLoop);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", (Object)BoxesRunTime.boxToLong((long)session.userId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUserStart(this.scenario.name());
        this.scenario.entry().$bang(session);
    }

    public void injectUser(FiniteDuration delay) {
        this.incrementScheduledUsers();
        long userId = this.userIdGen.incrementAndGet();
        EventLoop eventLoop = this.eventLoopGroup.next();
        if (!eventLoop.isShutdown()) {
            if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
                eventLoop.execute(() -> this.startUser(userId, eventLoop));
                return;
            }
            eventLoop.schedule(() -> this.startUser(userId, eventLoop), delay.toMillis(), TimeUnit.MILLISECONDS);
            return;
        }
    }

    public int getConcurrentUsers() {
        return (int)(this.scheduled() - this.stopped());
    }

    public String scenarioName() {
        return this.scenario.name();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser();

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public abstract FiniteDuration duration();

    public abstract boolean isEmpty();

    public Workload(Scenario scenario, AtomicLong userIdGen, EventLoopGroup eventLoopGroup, StatsEngine statsEngine) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.eventLoopGroup = eventLoopGroup;
        this.statsEngine = statsEngine;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0L;
        this.stopped = 0L;
        this.allScheduled = false;
        Statics.releaseFence();
    }
}

