/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.body.Body;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.SslContextsHolder;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.resolver.InetAddressNameResolverWrapper;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.HttpEngine$;
import io.gatling.http.protocol.HttpComponents;
import io.gatling.http.request.builder.Http;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.request.builder.RequestBuilder;
import io.gatling.http.resolver.InflightInetAddressNameResolver;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory;
import io.gatling.netty.util.Transports;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tMq!B\f\u0019\u0011\u0003\tc!B\u0012\u0019\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003qc\u0001B\u0012\u0019\u0005AB\u0001B\u0012\u0003\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u001b\u0012\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0002B\u0001B\u0003%Q\u000b\u0003\u0005^\t\t\u0005\t\u0015!\u0003_\u0011!)GA!A!\u0002\u00131\u0007\"B\u0016\u0005\t\u0003q\u0007B\u0002;\u0005A\u0003&Q\u000fC\u0003y\t\u0011\u0005\u0011\u0010C\u0004\u0002\f\u0011!\t!!\u0004\t\u000f\u0005-C\u0001\"\u0001\u0002N!9\u0011Q\u0010\u0003\u0005\u0002\u0005}\u0004bBAG\t\u0011\u0005\u0011q\u0012\u0005\n\u0003w#!\u0019!C\u0005\u0003{C\u0001\"!4\u0005A\u0003%\u0011q\u0018\u0005\b\u0003\u001f$A\u0011AAi\u0011\u001d\tY\u000e\u0002C\u0001\u0003;Dq!a?\u0005\t\u0003\ti\u0010C\u0004\u0003\u0004\u0011!\tE!\u0002\u0002\u0015!#H\u000f]#oO&tWM\u0003\u0002\u001a5\u00051QM\\4j]\u0016T!a\u0007\u000f\u0002\t!$H\u000f\u001d\u0006\u0003;y\tqaZ1uY&twMC\u0001 \u0003\tIwn\u0001\u0001\u0011\u0005\t\nQ\"\u0001\r\u0003\u0015!#H\u000f]#oO&tWm\u0005\u0002\u0002KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007=\u00129\u0001\u0005\u0002#\tM!A!M\u001d=!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u00142kK\u000e$\bC\u0001\u001a;\u0013\tY4GA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bAb]2bY\u0006dwnZ4j]\u001eT!!\u0011\"\u0002\u0011QL\b/Z:bM\u0016T\u0011aQ\u0001\u0004G>l\u0017BA#?\u00055\u0019FO]5di2{wmZ5oO\u0006\u00112o\u001d7D_:$X\r\u001f;t\r\u0006\u001cGo\u001c:z!\tA5*D\u0001J\u0015\tQ%$\u0001\u0003vi&d\u0017B\u0001'J\u0005I\u00196\u000f\\\"p]R,\u0007\u0010^:GC\u000e$xN]=\u0002\u0015!$H\u000f]\"mS\u0016tG\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R5\u000511\r\\5f]RL!a\u0015)\u0003\u0015!#H\u000f]\"mS\u0016tG/\u0001\bfm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016aB2iC:tW\r\u001c\u0006\u00035z\tQA\\3uifL!\u0001X,\u0003\u001d\u00153XM\u001c;M_>\u0004xI]8va\u0006)1\r\\8dWB\u0011qlY\u0007\u0002A*\u0011!*\u0019\u0006\u0003Er\tqaY8n[>t7/\u0003\u0002eA\n)1\t\\8dW\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\r\r|gNZ5h\u0015\tYG$\u0001\u0003d_J,\u0017BA7i\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]R1qf\u001c9reNDQA\u0012\u0006A\u0002\u001dCQ!\u0014\u0006A\u00029CQ\u0001\u0016\u0006A\u0002UCQ!\u0018\u0006A\u0002yCQ!\u001a\u0006A\u0002\u0019\f\u0001b^1s[\u0016$W\u000b\u001d\t\u0003MYL!a^\u0014\u0003\u000f\t{w\u000e\\3b]\u00061q/\u0019:n+B$\"A_?\u0011\u0005\u0019Z\u0018B\u0001?(\u0005\u0011)f.\u001b;\t\u000byd\u0001\u0019A@\u0002\u001d!$H\u000f]\"p[B|g.\u001a8ugB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006i\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\bIiR\u00048i\\7q_:,g\u000e^:\u0002\u001d\u0015DXmY;uKJ+\u0017/^3tiRi!0a\u0004\u0002\u001a\u0005\r\u0012qEA\u0019\u0003wAq!!\u0005\u000e\u0001\u0004\t\u0019\"A\u0007dY&,g\u000e\u001e*fcV,7\u000f\u001e\t\u0004\u001f\u0006U\u0011bAA\f!\n9!+Z9vKN$\bbBA\u000e\u001b\u0001\u0007\u0011QD\u0001\tG2LWM\u001c;JIB\u0019a%a\b\n\u0007\u0005\u0005rE\u0001\u0003M_:<\u0007BBA\u0013\u001b\u0001\u0007Q/\u0001\u0004tQ\u0006\u0014X\r\u001a\u0005\b\u0003Si\u0001\u0019AA\u0016\u0003%)g/\u001a8u\u0019>|\u0007\u000fE\u0002W\u0003[I1!a\fX\u0005%)e/\u001a8u\u0019>|\u0007\u000fC\u0004\u000245\u0001\r!!\u000e\u0002\u00111L7\u000f^3oKJ\u00042aTA\u001c\u0013\r\tI\u0004\u0015\u0002\r\u0011R$\b\u000fT5ti\u0016tWM\u001d\u0005\b\u0003{i\u0001\u0019AA \u0003=)8/\u001a:Tg2\u001cuN\u001c;fqR\u001c\b#\u0002\u0014\u0002B\u0005\u0015\u0013bAA\"O\t1q\n\u001d;j_:\u00042\u0001SA$\u0013\r\tI%\u0013\u0002\f'Nd7i\u001c8uKb$8/\u0001\u000bfq\u0016\u001cW\u000f^3IiR\u0004(GU3rk\u0016\u001cHo\u001d\u000b\fu\u0006=\u0013QOA<\u0003s\nY\bC\u0004\u0002R9\u0001\r!a\u0015\u0002)I,\u0017/^3tiN\fe\u000e\u001a'jgR,g.\u001a:t!\u0019\t)&!\u001a\u0002l9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/A\u00051AH]8pizJ\u0011\u0001K\u0005\u0004\u0003G:\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003O\nIG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\u0019g\n\t\t\u0003[\n\t(a\u0005\u000265\u0011\u0011q\u000e\u0006\u0003\u0015BKA!a\u001d\u0002p\t!\u0001+Y5s\u0011\u001d\tYB\u0004a\u0001\u0003;Aa!!\n\u000f\u0001\u0004)\bbBA\u0015\u001d\u0001\u0007\u00111\u0006\u0005\b\u0003{q\u0001\u0019AA \u0003YqWm\u001e&bm\u0006$en\u001d(b[\u0016\u0014Vm]8mm\u0016\u0014XCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD!\u0006A!/Z:pYZ,'/\u0003\u0003\u0002\f\u0006\u0015%aF%oKR\fE\r\u001a:fgNt\u0015-\\3SKN|GN^3s\u0003]qWm^!ts:\u001cGI\\:OC6,'+Z:pYZ,'\u000f\u0006\u0005\u0002\u0002\u0006E\u00151SAU\u0011\u001d\tI\u0003\u0005a\u0001\u0003WAq!!&\u0011\u0001\u0004\t9*\u0001\u0006e]N\u001cVM\u001d<feN\u0004RAJAM\u0003;K1!a'(\u0005\u0015\t%O]1z!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAARk\u0005\u0019a.\u001a;\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\bbBAV!\u0001\u0007\u0011QV\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005\u0003_\u000b9,\u0004\u0002\u00022*!\u00111WA[\u0003\r!gn\u001d\u0006\u0004\u0003\u000fK\u0016\u0002BA]\u0003c\u0013\u0001\u0002\u00128t\u0007\u0006\u001c\u0007.Z\u0001\u0014g\"\f'/\u001a3SKN|GN^3s\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u007f\u0003\u0002\"!1\u0002J\u0006-\u0012\u0011Q\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)+\u0014\u0002BAf\u0003\u0007\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003Q\u0019\b.\u0019:fIJ+7o\u001c7wKJ\u001c\u0015m\u00195fA\u0005!c.Z<TQ\u0006\u0014X\rZ!ts:\u001cGI\\:OC6,'+Z:pYZ,'OR1di>\u0014\u0018\u0010\u0006\u0003\u0002T\u0006e\u0007c\u0002\u0014\u0002V\u0006-\u0012\u0011Q\u0005\u0004\u0003/<#!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\t)j\u0005a\u0001\u0003/\u000baB\\3x'Nd7i\u001c8uKb$8\u000f\u0006\u0004\u0002F\u0005}\u00171\u001d\u0005\u0007\u0003C$\u0002\u0019A;\u0002\u0019!$H\u000f\u001d\u001aF]\u0006\u0014G.\u001a3\t\u000f\u0005\u0015H\u00031\u0001\u0002h\u0006A\u0002/\u001a:Vg\u0016\u00148*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0011\u000b\u0019\n\t%!;\u0011\t\u0005-\u0018q_\u0007\u0003\u0003[TA!a<\u0002r\u0006\u00191o\u001d7\u000b\t\u0005\r\u00161\u001f\u0006\u0003\u0003k\fQA[1wCbLA!!?\u0002n\n\t2*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0002+\u0019dWo\u001d5DY&,g\u000e^%e\u0007\"\fgN\\3mgR)!0a@\u0003\u0002!9\u00111D\u000bA\u0002\u0005u\u0001bBA\u0015+\u0001\u0007\u00111F\u0001\u0006G2|7/\u001a\u000b\u0002u\"9!\u0011B\u0002A\u0002\t-\u0011AD2pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\u0005\u0005\u001b\u0011y!D\u0001k\u0013\r\u0011\tB\u001b\u0002\u000f\u0007>\u0014XmQ8na>tWM\u001c;t\u0001")
public final class HttpEngine
implements AutoCloseable,
StrictLogging {
    private final SslContextsFactory sslContextsFactory;
    private final HttpClient httpClient;
    private final EventLoopGroup eventLoopGroup;
    private final GatlingConfiguration configuration;
    private boolean warmedUp;
    private final ConcurrentHashMap<EventLoop, InetAddressNameResolver> sharedResolverCache;
    private Logger logger;

    public static HttpEngine apply(CoreComponents coreComponents) {
        return HttpEngine$.MODULE$.apply(coreComponents);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void warmUp(HttpComponents httpComponents) {
        if (!this.warmedUp) {
            BoxedUnit boxedUnit;
            block19: {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Start warm up");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.warmedUp = true;
                Function1 expression = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)"foo"));
                ((HttpRequestBuilder)((RequestBuilder)new Http((Function1<Session, Validation<String>>)expression).get((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).queryParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression)).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                ((HttpRequestBuilder)new Http((Function1<Session, Validation<String>>)expression).post((Function1<Session, Validation<String>>)expression).body((Body)new StringBody(expression, this.configuration.core().charset()))).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                String url = (String)httpComponents.httpProtocol().warmUpUrl().getOrElse((Function0 & Serializable)() -> "https://gatling.io");
                io.gatling.http.client.RequestBuilder requestBuilder = new io.gatling.http.client.RequestBuilder("warmUp", HttpMethod.GET, Uri.create((String)url), InetAddressNameResolver.JAVA_RESOLVER).setHeaders(new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").add((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE, (Object)"en-US,en;q=0.5").add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE).add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/119.0")).setRequestTimeout(1000L).setDefaultCharset(this.configuration.core().charset());
                httpComponents.httpProtocol().proxyPart().proxy().foreach((Function1 & Serializable)x$1 -> requestBuilder.setProxyServer(x$1));
                EventLoop eventLoop = this.eventLoopGroup.next();
                SslContexts sslContexts = this.sslContextsFactory.newSslContexts(true, (Option<KeyManagerFactory>)None$.MODULE$);
                try {
                    BoxedUnit boxedUnit3;
                    try {
                        if (httpComponents.httpProtocol().warmUpUrl().isDefined()) {
                            Promise p = Promise$.MODULE$.apply();
                            this.httpClient.sendRequest(requestBuilder.build(), 0L, eventLoop, new HttpListener(null, p){
                                private final Promise p$1;

                                public void onSend() {
                                    super.onSend();
                                }

                                public void onProtocolAwareness(boolean x$1) {
                                    super.onProtocolAwareness(x$1);
                                }

                                public void onWrite(Channel x$1) {
                                    super.onWrite(x$1);
                                }

                                public void onFinalClientRequest(Request request) {
                                }

                                public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
                                }

                                public void onThrowable(Throwable throwable) {
                                    this.p$1.failure(throwable);
                                }

                                public void onHttpResponseBodyChunk(ByteBuf byteBuf, boolean last) {
                                    if (last) {
                                        this.p$1.success((Object)BoxedUnit.UNIT);
                                        return;
                                    }
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, (SslContextsHolder)sslContexts);
                            Await$.MODULE$.result((Awaitable)p.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds());
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Warm up request {} successful", (Object)url);
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            break block19;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            if (this.logger().underlying().isDebugEnabled()) {
                                if (this.logger().underlying().isDebugEnabled()) {
                                    this.logger().underlying().debug("Couldn't execute warm up request " + url, throwable2);
                                }
                            } else if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Couldn't execute warm up request {}: {}", new Object[]{url, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable2))});
                            }
                        } else {
                            throw throwable;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                }
                finally {
                    this.httpClient.flushClientIdChannels(0L, eventLoop);
                    sslContexts.close();
                }
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Warm up done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void executeRequest(Request clientRequest, long clientId, boolean shared, EventLoop eventLoop, HttpListener listener, Option<SslContexts> userSslContexts) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendRequest(clientRequest, shared ? -1L : clientId, eventLoop, listener, (SslContextsHolder)userSslContexts.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    public void executeHttp2Requests(Iterable<Pair<Request, HttpListener>> requestsAndListeners, long clientId, boolean shared, EventLoop eventLoop, Option<SslContexts> userSslContexts) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendHttp2Requests((Pair[])requestsAndListeners.toArray(ClassTag$.MODULE$.apply(Pair.class)), shared ? -1L : clientId, eventLoop, (SslContextsHolder)userSslContexts.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    public InetAddressNameResolver newJavaDnsNameResolver() {
        return InetAddressNameResolver.JAVA_RESOLVER;
    }

    public InetAddressNameResolver newAsyncDnsNameResolver(EventLoop eventLoop, InetSocketAddress[] dnsServers, DnsCache cache) {
        return new InetAddressNameResolverWrapper((NameResolver)new DnsNameResolverBuilder(eventLoop).channelFactory(Transports.newDatagramChannelFactory((boolean)this.configuration.netty().useNativeTransport(), (boolean)this.configuration.netty().useIoUring())).nameServerProvider((DnsServerAddressStreamProvider)(dnsServers.length == 0 ? DnsServerAddressStreamProviders.platformDefault() : new SequentialDnsServerAddressStreamProvider(dnsServers))).queryTimeoutMillis((long)((int)this.configuration.http().dns().queryTimeout().toMillis())).maxQueriesPerResolve(this.configuration.http().dns().maxQueriesPerResolve()).resolveCache(cache).build());
    }

    private ConcurrentHashMap<EventLoop, InetAddressNameResolver> sharedResolverCache() {
        return this.sharedResolverCache;
    }

    public Function1<EventLoop, InetAddressNameResolver> newSharedAsyncDnsNameResolverFactory(InetSocketAddress[] dnsServers) {
        ConcurrentHashMap inProgressResolutions = new ConcurrentHashMap();
        DefaultDnsCache sharedCache = new DefaultDnsCache();
        Function<EventLoop, InetAddressNameResolver> computer = arg_0 -> HttpEngine.$anonfun$newSharedAsyncDnsNameResolverFactory$1(this, dnsServers, (DnsCache)sharedCache, inProgressResolutions, arg_0);
        return (Function1 & Serializable)eventLoop -> this.sharedResolverCache().computeIfAbsent((EventLoop)eventLoop, computer);
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        return this.sslContextsFactory.newSslContexts(http2Enabled, perUserKeyManagerFactory);
    }

    public void flushClientIdChannels(long clientId, EventLoop eventLoop) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.flushClientIdChannels(clientId, eventLoop);
            return;
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
        this.sharedResolverCache().values().forEach(x$1 -> x$1.close());
    }

    public static final /* synthetic */ InetAddressNameResolver $anonfun$newSharedAsyncDnsNameResolverFactory$1(HttpEngine $this, InetSocketAddress[] dnsServers$1, DnsCache sharedCache$1, ConcurrentHashMap inProgressResolutions$1, EventLoop el) {
        InetAddressNameResolver actualResolver = $this.newAsyncDnsNameResolver(el, dnsServers$1, sharedCache$1);
        return new InflightInetAddressNameResolver(actualResolver, inProgressResolutions$1);
    }

    public HttpEngine(SslContextsFactory sslContextsFactory, HttpClient httpClient, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.sslContextsFactory = sslContextsFactory;
        this.httpClient = httpClient;
        this.eventLoopGroup = eventLoopGroup;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        this.warmedUp = false;
        this.sharedResolverCache = new ConcurrentHashMap();
        Statics.releaseFence();
    }
}

