/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.auth;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.http.auth.DigestAuth;
import io.gatling.http.auth.DigestAuth$;
import io.gatling.http.auth.DigestAuthChallengeStore;
import io.gatling.http.auth.DigestAuthChallengeStore$;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.List;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class DigestAuthSupport$
implements StrictLogging {
    public static final DigestAuthSupport$ MODULE$ = new DigestAuthSupport$();
    private static final String DigestAuthChallengesAttributeName;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        DigestAuthChallengesAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.auth.digest");
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String DigestAuthChallengesAttributeName() {
        return DigestAuthChallengesAttributeName;
    }

    private Option<DigestAuthChallengeStore> getStore(Session session) {
        return session.attributes().get((Object)this.DigestAuthChallengesAttributeName()).map((Function1 & Serializable)x$1 -> (DigestAuthChallengeStore)x$1);
    }

    public Option<String> io$gatling$http$auth$DigestAuthSupport$$getAuthorization(Session session, HttpMethod requestMethod, Uri requestUri, String username, String password) {
        return this.getStore(session).flatMap((Function1 & Serializable)store -> store.getAuthorization(requestMethod, requestUri, username, password));
    }

    private DigestAuthChallengeStore getOrCreateDigestAuthChallenges(Session session) {
        Option<DigestAuthChallengeStore> option = this.getStore(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            DigestAuthChallengeStore digestAuthChallenges = (DigestAuthChallengeStore)some.value();
            return digestAuthChallenges;
        }
        return DigestAuthChallengeStore$.MODULE$.Empty();
    }

    public Session storeChallenges(Session session, Seq<DigestAuth.Challenge> challenges) {
        DigestAuthChallengeStore store = this.getOrCreateDigestAuthChallenges(session);
        return session.set(this.DigestAuthChallengesAttributeName(), (Object)store.storeChallenges(challenges));
    }

    public Seq<DigestAuth.Challenge> extractChallenges(HttpHeaders headers, Uri requestUri) {
        List authenticateHeaders = headers.getAll((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE);
        if (authenticateHeaders == null || authenticateHeaders.isEmpty()) {
            return Nil$.MODULE$;
        }
        return (Seq)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(authenticateHeaders).asScala().toSeq().collect((PartialFunction)new Serializable(requestUri){
            private static final long serialVersionUID = 0L;
            private final Uri requestUri$2;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.startsWith("Digest ")) {
                    return (B1)DigestAuth$.MODULE$.parseWwwAuthenticateHeader(A1, this.requestUri$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return string.startsWith("Digest ");
            }
            {
                this.requestUri$2 = requestUri$2;
            }
        })).flatMap((Function1 & Serializable)x0$1 -> {
            Validation validation = x0$1;
            if (validation instanceof Success) {
                DigestAuth.Challenge challenge;
                Success success = (Success)validation;
                DigestAuth.Challenge challenge2 = challenge = (DigestAuth.Challenge)success.value();
                return Nil$.MODULE$.$colon$colon((Object)challenge2);
            }
            if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String error = failure.message();
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Failed to parse Digest header: {}", (Object)error);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)validation);
        });
    }

    public DigestRealm realmWithAuthorizationGen(Session session, DigestRealm digestRealm) {
        return digestRealm.withAuthorizationGen(new DigestRealm.AuthorizationGen(session){
            private final Session session$1;

            public String apply(HttpMethod requestMethod, Uri requestUri, String username, String password) {
                return (String)DigestAuthSupport$.MODULE$.io$gatling$http$auth$DigestAuthSupport$$getAuthorization(this.session$1, requestMethod, requestUri, username, password).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                this.session$1 = session$1;
            }
        });
    }

    private DigestAuthSupport$() {
    }
}

