/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.RequestContainer;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E2Q!\u0002\u0004\u0003\u0011AA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006;\u0001!\tA\b\u0005\u0006C\u0001!\tE\t\u0005\u0006a\u0001!\tE\t\u0002\u001a%\u0016\fX/Z:u\u0007>,h\u000e\u001e)pY\u0006\u0014H+Z7qY\u0006$XM\u0003\u0002\b\u0011\u0005AA/Z7qY\u0006$XM\u0003\u0002\n\u0015\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7C\u0001\u0001\u0012!\t\u00112#D\u0001\u0007\u0013\t!bA\u0001\u0005UK6\u0004H.\u0019;f\u00035\u0011xn\u001c;D_:$\u0018-\u001b8fe\u000e\u0001\u0001C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u000b\u0003\u0019\u0011X\r]8si&\u0011A$\u0007\u0002\u000f\u000fJ|W\u000f]\"p]R\f\u0017N\\3s\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u0003%\u0001AQ!\u0006\u0002A\u0002]\t!A[:\u0016\u0003\r\u0002\"\u0001J\u0017\u000f\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0017\u0003\u0019a$o\\8u})\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013&\u0001\u0003ii6d\u0007")
public final class RequestCountPolarTemplate
extends Template {
    private final GroupContainer rootContainer;

    @Override
    public String js() {
        List requestContainers = RequestCountPolarTemplate.collectRequestContainersRec$1(this.rootContainer);
        double ticksInterval = package$.MODULE$.ceil((double)requestContainers.size() / 1000.0);
        String categories = requestContainers.map((Function1 & Serializable)x$1 -> x$1.name().replace("'", "&#39;")).mkString("['", "', '", "']");
        String okData = requestContainers.map((Function1 & Serializable)container -> BoxesRunTime.boxToLong((long)RequestCountPolarTemplate.$anonfun$js$3(container))).mkString("[", ", ", "]");
        String koData = requestContainers.map((Function1 & Serializable)container -> BoxesRunTime.boxToLong((long)RequestCountPolarTemplate.$anonfun$js$5(container))).mkString("[", ", ", "]");
        return "\nvar tickInterval = " + ticksInterval + ";\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo:'container_number_of_requests',\n    polar:true,\n    type:'column',\n    height:330\n  },\n  credits:{\n    enabled:false\n  },\n  title:{\n    text:'<span class=\"chart_title\">Number of requests</span>',\n    useHTML: true,\n    widthAdjust:-20\n  },\n  xAxis:{\n    tickmarkPlacement:'on',\n    tickInterval: tickInterval,\n    categories: " + categories + ",\n    labels:{ enabled:false }\n  },\n  yAxis:{\n    min:0,\n    reversedStacks: false\n  },\n  plotOptions:{\n    series:{\n      stacking:'normal',\n      groupPadding:0,\n      pointPlacement:'on',\n      shadow: true\n    }\n  },\n  legend: {\n      borderWidth: 0,\n      itemStyle: { fontWeight: \"normal\" },\n      symbolRadius: 0\n  },\n  series:[\n      {\n      name:'OK',\n      data:" + okData + ",\n      color:\"" + Color.Requests$.MODULE$.Ok() + "\"\n    },\n    {\n      name:'KO',\n      data:" + koData + ",\n      color:\"" + Color.Requests$.MODULE$.Ko() + "\"\n    }\n  ]\n});\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema polar\">\n              <div id=\"container_number_of_requests\"></div>\n            </div>\n";
    }

    private static final List collectRequestContainersRec$1(GroupContainer groupContainer2) {
        List list = ((IterableOnceOps)groupContainer2.groups().values().flatMap((Function1 & Serializable)groupContainer -> RequestCountPolarTemplate.collectRequestContainersRec$1(groupContainer))).toList();
        return groupContainer2.requests().values().toList().$colon$colon$colon(list);
    }

    public static final /* synthetic */ long $anonfun$js$3(RequestContainer container) {
        return BoxesRunTime.unboxToLong((Object)container.stats().numberOfRequestsStatistics().success().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$js$5(RequestContainer container) {
        return BoxesRunTime.unboxToLong((Object)container.stats().numberOfRequestsStatistics().failure().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public RequestCountPolarTemplate(GroupContainer rootContainer) {
        this.rootContainer = rootContainer;
    }
}

