/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.execute;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ProtocArgumentBuilder {
    private final List<String> arguments = new ArrayList<String>();

    public ProtocArgumentBuilder(Path executablePath) {
        this.arguments.add(executablePath.toString());
    }

    public List<String> version() {
        this.arguments.add("--version");
        return List.copyOf(this.arguments);
    }

    public ProtocArgumentBuilder includeDirectories(Collection<Path> directories) {
        for (Path directory : directories) {
            this.arguments.add("--proto_path=" + directory);
        }
        return this;
    }

    public ProtocArgumentBuilder plugin(String pluginName, Path pluginPath) {
        String arg = "--plugin=" + pluginName + "=" + pluginPath;
        this.arguments.add(arg);
        return this;
    }

    public ProtocArgumentBuilder outputDirectory(String outputType, Path outputDirectory, boolean lite) {
        StringBuilder arg = new StringBuilder("--").append(outputType).append("_out=");
        if (lite) {
            arg.append("lite:");
        }
        arg.append(outputDirectory);
        this.arguments.add(arg.toString());
        return this;
    }

    public ProtocArgumentBuilder fatalWarnings(boolean fatalWarnings) {
        if (fatalWarnings) {
            this.arguments.add("--fatal_warnings");
        }
        return this;
    }

    public List<String> build(Collection<Path> protoFiles) {
        for (Path protoFile : protoFiles) {
            this.arguments.add(protoFile.toString());
        }
        return List.copyOf(this.arguments);
    }
}

