/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generate;

import io.github.ascopes.protobufmavenplugin.execute.ProtocArgumentBuilder;
import io.github.ascopes.protobufmavenplugin.execute.ProtocExecutionException;
import io.github.ascopes.protobufmavenplugin.execute.ProtocExecutor;
import io.github.ascopes.protobufmavenplugin.generate.SourceGeneratorBuilder;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolver;
import io.github.ascopes.protobufmavenplugin.resolve.grpc.MavenGrpcJavaPluginResolver;
import io.github.ascopes.protobufmavenplugin.resolve.grpc.MavenGrpcKotlinPluginResolver;
import io.github.ascopes.protobufmavenplugin.resolve.grpc.PathGrpcJavaPluginResolver;
import io.github.ascopes.protobufmavenplugin.resolve.grpc.PathGrpcKotlinPluginResolver;
import io.github.ascopes.protobufmavenplugin.resolve.protoc.MavenProtocResolver;
import io.github.ascopes.protobufmavenplugin.resolve.protoc.PathProtocResolver;
import io.github.ascopes.protobufmavenplugin.resolve.source.ProtoSourceResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceGenerator.class);
    private final ArtifactResolver artifactResolver;
    private final MavenSession mavenSession;
    private final String protocVersion;
    private final @Nullable String grpcPluginVersion;
    private final Set<Path> sourceDirectories;
    private final Path protobufOutputDirectory;
    private final Path grpcOutputDirectory;
    private final boolean fatalWarnings;
    private final boolean generateKotlinWrappers;
    private final boolean liteOnly;
    private final SourceRootRegistrar sourceRootRegistrar;

    SourceGenerator(SourceGeneratorBuilder builder) {
        this.artifactResolver = Objects.requireNonNull(builder.artifactResolver);
        this.mavenSession = Objects.requireNonNull(builder.mavenSession);
        this.protocVersion = Objects.requireNonNull(builder.protocVersion);
        this.grpcPluginVersion = builder.grpcPluginVersion;
        this.sourceDirectories = Objects.requireNonNull(builder.sourceDirectories);
        this.protobufOutputDirectory = Objects.requireNonNull(builder.protobufOutputDirectory);
        this.grpcOutputDirectory = Objects.requireNonNull(builder.grpcOutputDirectory);
        this.fatalWarnings = Objects.requireNonNull(builder.fatalWarnings);
        this.generateKotlinWrappers = Objects.requireNonNull(builder.generateKotlinWrappers);
        this.liteOnly = Objects.requireNonNull(builder.liteOnly);
        this.sourceRootRegistrar = Objects.requireNonNull(builder.sourceRootRegistrar);
    }

    public void generate() throws MojoExecutionException, MojoFailureException {
        LOGGER.debug("Beginning generation pass");
        Path protocPath = this.resolveProtocPath();
        Collection<Plugin> pluginPaths = this.resolvePlugins();
        List<Path> sources = this.resolveProtoSources();
        this.registerSourceOutputRoots();
        this.dumpProtocVersion(protocPath);
        this.generateSources(protocPath, pluginPaths, sources);
    }

    Path resolveProtocPath() throws MojoFailureException {
        ExecutableResolver resolver = this.protocVersion.trim().equalsIgnoreCase("PATH") ? new PathProtocResolver() : new MavenProtocResolver(this.protocVersion, this.artifactResolver, this.mavenSession);
        try {
            return resolver.resolve();
        }
        catch (ExecutableResolutionException ex) {
            throw this.failure("Failed to resolve protoc executable", ex);
        }
    }

    Collection<Plugin> resolvePlugins() throws MojoFailureException {
        if (this.grpcPluginVersion == null) {
            return List.of();
        }
        boolean usePath = this.grpcPluginVersion.trim().equalsIgnoreCase("PATH");
        ArrayList<Plugin> resolvedPluginPaths = new ArrayList<Plugin>();
        try {
            ExecutableResolver javaResolver = usePath ? new PathGrpcJavaPluginResolver() : new MavenGrpcJavaPluginResolver(this.grpcPluginVersion, this.artifactResolver, this.mavenSession);
            resolvedPluginPaths.add(new Plugin("protoc-gen-grpc-java", javaResolver.resolve()));
        }
        catch (ExecutableResolutionException ex) {
            throw this.failure("Failed to resolve Java GRPC plugin executable", ex);
        }
        if (this.generateKotlinWrappers) {
            try {
                ExecutableResolver kotlinResolver = usePath ? new PathGrpcKotlinPluginResolver() : new MavenGrpcKotlinPluginResolver(this.grpcPluginVersion, this.artifactResolver, this.mavenSession);
                resolvedPluginPaths.add(new Plugin("protoc-gen-grpc-kotlin", kotlinResolver.resolve()));
            }
            catch (ExecutableResolutionException ex) {
                throw this.failure("Failed to resolve Kotlin GRPC plugin executables", ex);
            }
        }
        return resolvedPluginPaths;
    }

    private List<Path> resolveProtoSources() throws MojoFailureException {
        try {
            return ProtoSourceResolver.resolve(this.sourceDirectories);
        }
        catch (IOException ex) {
            throw this.failure("Failed to resolve protobuf sources", ex);
        }
    }

    void registerSourceOutputRoots() throws MojoFailureException {
        try {
            Files.createDirectories(this.protobufOutputDirectory, new FileAttribute[0]);
            this.sourceRootRegistrar.register(this.mavenSession.getCurrentProject(), this.protobufOutputDirectory);
        }
        catch (IOException ex) {
            throw this.failure("Failed to register protobuf output root", ex);
        }
        if (this.grpcPluginVersion != null) {
            try {
                Files.createDirectories(this.grpcOutputDirectory, new FileAttribute[0]);
                this.sourceRootRegistrar.register(this.mavenSession.getCurrentProject(), this.grpcOutputDirectory);
            }
            catch (IOException ex) {
                throw this.failure("Failed to register GRPC output root", ex);
            }
        }
    }

    void dumpProtocVersion(Path protocPath) throws MojoFailureException {
        try {
            ProtocExecutor.invoke(new ProtocArgumentBuilder(protocPath).version());
        }
        catch (ProtocExecutionException ex) {
            throw this.failure("Failed to determine protoc version", ex);
        }
    }

    void generateSources(Path protocPath, Collection<Plugin> plugins, Collection<Path> sources) throws MojoExecutionException {
        ProtocArgumentBuilder argBuilder = new ProtocArgumentBuilder(protocPath).includeDirectories(this.sourceDirectories).fatalWarnings(this.fatalWarnings).outputDirectory("java", this.protobufOutputDirectory, this.liteOnly);
        for (Plugin plugin : plugins) {
            argBuilder.plugin(plugin.name, plugin.path);
        }
        if (this.grpcPluginVersion != null) {
            argBuilder.outputDirectory("grpc-java", this.grpcOutputDirectory, false);
        }
        if (this.generateKotlinWrappers) {
            argBuilder.outputDirectory("kotlin", this.protobufOutputDirectory, this.liteOnly);
            if (this.grpcPluginVersion != null) {
                argBuilder.outputDirectory("grpc-kotlin", this.grpcOutputDirectory, false);
            }
        }
        try {
            ProtocExecutor.invoke(argBuilder.build(sources));
        }
        catch (ProtocExecutionException ex) {
            throw this.error("Compilation of protobuf sources failed", ex);
        }
    }

    private MojoExecutionException error(String shortMessage, Exception ex) {
        MojoExecutionException newEx = new MojoExecutionException((Object)this, shortMessage, this.getLongMessage(shortMessage, ex));
        newEx.initCause((Throwable)ex);
        return newEx;
    }

    private MojoFailureException failure(String shortMessage, Exception ex) {
        MojoFailureException newEx = new MojoFailureException((Object)this, shortMessage, this.getLongMessage(shortMessage, ex));
        newEx.initCause((Throwable)ex);
        return newEx;
    }

    private String getLongMessage(String shortMessage, Exception ex) {
        return Optional.ofNullable(ex).map(Throwable::getMessage).orElse(shortMessage);
    }

    private static final class Plugin {
        private final String name;
        private final Path path;

        private Plugin(String name, Path path) {
            this.name = name;
            this.path = path;
        }
    }
}

