/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve;

import io.github.ascopes.protobufmavenplugin.platform.HostEnvironment;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenCoordinateFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMavenCoordinateFactory.class);

    public abstract ArtifactCoordinate create(String var1) throws ExecutableResolutionException;

    protected abstract String name();

    protected final String determineClassifier() throws ExecutableResolutionException {
        String classifier;
        if (HostEnvironment.isWindows()) {
            classifier = "windows-" + this.determineArchitectureForWindows();
        } else if (HostEnvironment.isLinux()) {
            classifier = "linux-" + this.determineArchitectureForLinux();
        } else if (HostEnvironment.isMacOs()) {
            classifier = "osx-" + this.determineArchitectureForMacOs();
        } else {
            throw new ExecutableResolutionException("No resolvable version of " + this.name() + " for the current OS found");
        }
        LOGGER.debug("Will use {} as the {} artifact classifier", (Object)classifier, (Object)this.name());
        return classifier;
    }

    private String determineArchitectureForWindows() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "amd64": 
            case "x86_64": {
                return "x86_64";
            }
            case "x86": 
            case "x86_32": {
                return "x86_32";
            }
        }
        throw this.noResolvableProtocFor("Windows", arch);
    }

    private String determineArchitectureForLinux() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "ppc64le": 
            case "ppc64": {
                return "ppcle_64";
            }
            case "s390": 
            case "zarch_64": {
                return "s390_64";
            }
            case "aarch64": {
                return "aarch_64";
            }
            case "amd64": {
                return "x86_64";
            }
        }
        throw this.noResolvableProtocFor("Linux", arch);
    }

    private String determineArchitectureForMacOs() throws ExecutableResolutionException {
        String arch;
        switch (arch = HostEnvironment.cpuArchitecture()) {
            case "aarch64": {
                return "aarch_64";
            }
            case "amd64": 
            case "x86_64": {
                return "x86_64";
            }
        }
        throw this.noResolvableProtocFor("Mac OS", arch);
    }

    private ExecutableResolutionException noResolvableProtocFor(String os, String arch) {
        String message = "No resolvable " + this.name() + " version for " + os + " '" + arch + "' systems found";
        return new ExecutableResolutionException(message);
    }
}

