/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve;

import io.github.ascopes.protobufmavenplugin.platform.HostEnvironment;
import io.github.ascopes.protobufmavenplugin.resolve.AbstractMavenCoordinateFactory;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenResolver
implements ExecutableResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMavenResolver.class);
    private final String version;
    private final ArtifactResolver artifactResolver;
    private final MavenSession mavenSession;
    private final AbstractMavenCoordinateFactory coordinateFactory;

    protected AbstractMavenResolver(String version, ArtifactResolver artifactResolver, MavenSession mavenSession, AbstractMavenCoordinateFactory coordinateFactory) {
        this.version = version;
        this.artifactResolver = artifactResolver;
        this.mavenSession = mavenSession;
        this.coordinateFactory = coordinateFactory;
    }

    @Override
    public Path resolve() throws ExecutableResolutionException {
        Path path;
        ArtifactCoordinate coordinate = this.coordinateFactory.create(this.version);
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            LOGGER.info("Resolving {} from Maven repositories", (Object)coordinate);
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)request, coordinate);
            path = result.getArtifact().getFile().toPath();
        }
        catch (ArtifactResolverException ex) {
            throw new ExecutableResolutionException("Failed to resolve " + coordinate + " from Maven repositories", ex);
        }
        LOGGER.info("Resolved {} to local path '{}'", (Object)coordinate, (Object)path);
        if (!HostEnvironment.isWindows()) {
            LOGGER.debug("Ensuring '{}' is marked as executable", (Object)path);
            try {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException ex) {
                throw new ExecutableResolutionException("Setting executable bit for '" + path + "' failed", ex);
            }
        }
        return path;
    }
}

