/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.resolve.protoc;

import io.github.ascopes.protobufmavenplugin.platform.HostEnvironment;
import io.github.ascopes.protobufmavenplugin.resolve.AbstractMavenCoordinateFactory;
import io.github.ascopes.protobufmavenplugin.resolve.ExecutableResolutionException;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenProtocCoordinateFactory
extends AbstractMavenCoordinateFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProtocCoordinateFactory.class);
    private static final String GROUP_ID = "com.google.protobuf";
    private static final String ARTIFACT_ID = "protoc";
    private static final String EXTENSION = "exe";

    @Override
    public ArtifactCoordinate create(String versionRange) throws ExecutableResolutionException {
        this.emitPlatformWarnings();
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(GROUP_ID);
        coordinate.setArtifactId(ARTIFACT_ID);
        coordinate.setVersion(versionRange);
        coordinate.setClassifier(this.determineClassifier());
        coordinate.setExtension(EXTENSION);
        return coordinate;
    }

    @Override
    protected String name() {
        return ARTIFACT_ID;
    }

    private void emitPlatformWarnings() {
        if (HostEnvironment.workingDirectory().toString().startsWith("/data/data/com.termux")) {
            LOGGER.warn("It appears you are running on Termux. You may have difficulties invoking the 'protoc' executable from Maven Central. If this is an issue, install protoc directly ('pkg in protoc'), and invoke Maven with '-Dprotoc.version=PATH' instead.");
        }
    }
}

