/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.Plugin;
import io.github.ascopes.protobufmavenplugin.dependency.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformArtifactFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.system.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;

@Named
public final class BinaryPluginResolver {
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final PlatformArtifactFactory platformDependencyFactory;
    private final SystemPathBinaryResolver systemPathResolver;

    @Inject
    public BinaryPluginResolver(MavenDependencyPathResolver mavenDependencyPathResolver, PlatformArtifactFactory platformDependencyFactory, SystemPathBinaryResolver systemPathResolver) {
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.platformDependencyFactory = platformDependencyFactory;
        this.systemPathResolver = systemPathResolver;
    }

    public Collection<ResolvedPlugin> resolveAll(MavenSession session, Collection<Plugin> pluginBeans) throws ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (Plugin pluginBean : pluginBeans) {
            Path path = this.resolvePath(session, pluginBean);
            ImmutableResolvedPlugin resolvedPlugin = ImmutableResolvedPlugin.builder().id(path.getFileName().toString()).path(path).build();
            resolvedPlugins.add(resolvedPlugin);
        }
        return resolvedPlugins;
    }

    private Path resolvePath(MavenSession session, Plugin pluginBean) throws ResolutionException {
        if (pluginBean.getArtifact().isPresent()) {
            ArtifactCoordinate coordinate = this.enrich(pluginBean.getArtifact().get());
            try {
                Path path = this.mavenDependencyPathResolver.resolveArtifact(session, coordinate);
                FileUtils.makeExecutable(path);
                return path;
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
            }
        }
        String executableName = pluginBean.getExecutableName().orElseThrow();
        return this.systemPathResolver.resolve(executableName).orElseThrow(() -> new ResolutionException("No executable '" + executableName + "' was found on the system path"));
    }

    private ArtifactCoordinate enrich(ArtifactCoordinate coordinate) {
        String extension = coordinate.getExtension().equals("jar") ? null : coordinate.getExtension();
        return this.platformDependencyFactory.createArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion(), extension, coordinate.getClassifier());
    }
}

