/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.system.HostSystem;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.jspecify.annotations.Nullable;

@Named
public final class PlatformArtifactFactory {
    private final HostSystem hostSystem;

    @Inject
    public PlatformArtifactFactory(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public ArtifactCoordinate createArtifact(String groupId, String artifactId, String version, @Nullable String extension, @Nullable String classifier) {
        DefaultArtifactCoordinate dependency = new DefaultArtifactCoordinate();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setExtension(Objects.requireNonNullElse(extension, "exe"));
        dependency.setClassifier(Objects.requireNonNullElseGet(classifier, () -> this.getPlatformExecutableClassifier(artifactId)));
        return dependency;
    }

    private String getPlatformExecutableClassifier(String artifactId) {
        String rawOs = this.hostSystem.getOperatingSystem();
        String rawArch = this.hostSystem.getCpuArchitecture();
        if (this.hostSystem.isProbablyLinux()) {
            switch (rawArch) {
                case "ppc64le": 
                case "ppc64": {
                    return "linux-ppcle_64";
                }
                case "s390": 
                case "zarch_64": {
                    return "linux-s390_64";
                }
                case "aarch64": {
                    return "linux-aarch_64";
                }
                case "amd64": {
                    return "linux-x86_64";
                }
            }
        } else if (this.hostSystem.isProbablyMacOs()) {
            switch (rawArch) {
                case "aarch64": {
                    return "osx-aarch_64";
                }
                case "amd64": 
                case "x86_64": {
                    return "osx-x86_64";
                }
            }
        } else if (this.hostSystem.isProbablyWindows()) {
            switch (rawArch) {
                case "amd64": 
                case "x86_64": {
                    return "windows-x86_64";
                }
                case "x86": 
                case "x86_32": {
                    return "windows-x86_32";
                }
            }
        }
        String message = String.format("No '%s' binary is available for reported OS '%s' and CPU architecture '%s'", artifactId, rawOs, rawArch);
        throw new UnsupportedOperationException(message);
    }
}

