/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformArtifactFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.system.FileUtils;
import io.github.ascopes.protobufmavenplugin.system.HostSystem;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtocResolver {
    private static final String EXECUTABLE_NAME = "protoc";
    private static final String GROUP_ID = "com.google.protobuf";
    private static final String ARTIFACT_ID = "protoc";
    private static final Logger log = LoggerFactory.getLogger(ProtocResolver.class);
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final PlatformArtifactFactory platformArtifactFactory;
    private final SystemPathBinaryResolver systemPathResolver;

    @Inject
    public ProtocResolver(HostSystem hostSystem, MavenDependencyPathResolver mavenDependencyPathResolver, PlatformArtifactFactory platformArtifactFactory, SystemPathBinaryResolver systemPathResolver) {
        this.hostSystem = hostSystem;
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.platformArtifactFactory = platformArtifactFactory;
        this.systemPathResolver = systemPathResolver;
    }

    public Path resolve(MavenSession session, String version) throws ResolutionException {
        if (version.equalsIgnoreCase("PATH")) {
            return this.systemPathResolver.resolve("protoc").orElseThrow(() -> new ResolutionException("No protoc executable was found"));
        }
        if (this.hostSystem.isProbablyAndroidTermux()) {
            log.warn("It looks like you are using Termux on Android. You may encounter issues running the detected protoc binary from Maven central. If this is an issue, install the protoc compiler manually from your package manager (apt update && apt install protobuf), and then invoke Maven with the -Dprotoc.version=PATH flag to avoid this.");
        }
        ArtifactCoordinate coordinate = this.platformArtifactFactory.createArtifact(GROUP_ID, "protoc", version, null, null);
        try {
            Path path = this.mavenDependencyPathResolver.resolveArtifact(session, coordinate);
            FileUtils.makeExecutable(path);
            return path;
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc binary", ex);
        }
    }
}

