/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.execute;

import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ArgLineBuilder {
    private final List<String> args = new ArrayList<String>();
    private int outputTargetCount;

    public ArgLineBuilder(Path protocPath) {
        this.args.add(protocPath.toString());
        this.outputTargetCount = 0;
    }

    public List<String> compile(Collection<Path> sourcesToCompile) {
        if (this.outputTargetCount == 0) {
            throw new IllegalStateException("No output targets were provided");
        }
        for (Path path : sourcesToCompile) {
            this.args.add(path.toString());
        }
        return this.args;
    }

    public ArgLineBuilder fatalWarnings(boolean fatalWarnings) {
        if (fatalWarnings) {
            this.args.add("--fatal_warnings");
        }
        return this;
    }

    public ArgLineBuilder importPaths(Collection<Path> includePaths) {
        for (Path includePath : includePaths) {
            this.args.add("--proto_path=" + includePath);
        }
        return this;
    }

    public ArgLineBuilder javaOut(Path outputPath, boolean lite) {
        ++this.outputTargetCount;
        String flag = lite ? "--java_out=lite:" : "--java_out=";
        this.args.add(flag + outputPath);
        return this;
    }

    public ArgLineBuilder kotlinOut(Path outputPath, boolean lite) {
        ++this.outputTargetCount;
        String flag = lite ? "--kotlin_out=lite:" : "--kotlin_out=";
        this.args.add(flag + outputPath);
        return this;
    }

    public ArgLineBuilder plugins(Collection<ResolvedPlugin> plugins, Path outputPath) {
        for (ResolvedPlugin plugin : plugins) {
            ++this.outputTargetCount;
            this.args.add("--plugin=protoc-gen-" + plugin.getId() + "=" + plugin.getPath());
            this.args.add("--" + plugin.getId() + "_out=" + outputPath);
        }
        return this;
    }
}

