/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.source;

import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="ProtoFileListing", generator="Immutables")
public final class ImmutableProtoFileListing
implements ProtoFileListing {
    private final Path originalRoot;
    private final Path protoFilesRoot;
    private final Set<Path> protoFiles;

    private ImmutableProtoFileListing(Path originalRoot, Path protoFilesRoot, Set<Path> protoFiles) {
        this.originalRoot = originalRoot;
        this.protoFilesRoot = protoFilesRoot;
        this.protoFiles = protoFiles;
    }

    @Override
    public Path getOriginalRoot() {
        return this.originalRoot;
    }

    @Override
    public Path getProtoFilesRoot() {
        return this.protoFilesRoot;
    }

    @Override
    public Set<Path> getProtoFiles() {
        return this.protoFiles;
    }

    public final ImmutableProtoFileListing withOriginalRoot(Path value) {
        if (this.originalRoot == value) {
            return this;
        }
        return new ImmutableProtoFileListing(value, this.protoFilesRoot, this.protoFiles);
    }

    public final ImmutableProtoFileListing withProtoFilesRoot(Path value) {
        if (this.protoFilesRoot == value) {
            return this;
        }
        return new ImmutableProtoFileListing(this.originalRoot, value, this.protoFiles);
    }

    public final ImmutableProtoFileListing withProtoFiles(Path ... elements) {
        Set<Path> newValue = ImmutableProtoFileListing.createUnmodifiableSet(ImmutableProtoFileListing.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableProtoFileListing(this.originalRoot, this.protoFilesRoot, newValue);
    }

    public final ImmutableProtoFileListing withProtoFiles(Iterable<? extends Path> elements) {
        if (this.protoFiles == elements) {
            return this;
        }
        Set<Path> newValue = ImmutableProtoFileListing.createUnmodifiableSet(ImmutableProtoFileListing.createSafeList(elements, false, false));
        return new ImmutableProtoFileListing(this.originalRoot, this.protoFilesRoot, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtoFileListing && this.equalTo(0, (ImmutableProtoFileListing)another);
    }

    private boolean equalTo(int synthetic, ImmutableProtoFileListing another) {
        return Objects.equals(this.originalRoot, another.originalRoot) && Objects.equals(this.protoFilesRoot, another.protoFilesRoot) && this.protoFiles.equals(another.protoFiles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.originalRoot);
        h += (h << 5) + Objects.hashCode(this.protoFilesRoot);
        h += (h << 5) + this.protoFiles.hashCode();
        return h;
    }

    public String toString() {
        return "ProtoFileListing{originalRoot=" + this.originalRoot + ", protoFilesRoot=" + this.protoFilesRoot + ", protoFiles=" + this.protoFiles + "}";
    }

    public static ImmutableProtoFileListing copyOf(ProtoFileListing instance) {
        if (instance instanceof ImmutableProtoFileListing) {
            return (ImmutableProtoFileListing)instance;
        }
        return ImmutableProtoFileListing.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="ProtoFileListing", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ORIGINAL_ROOT = 1L;
        private static final long INIT_BIT_PROTO_FILES_ROOT = 2L;
        private long initBits = 3L;
        private Path originalRoot;
        private Path protoFilesRoot;
        private List<Path> protoFiles = new ArrayList<Path>();

        private Builder() {
        }

        public final Builder from(ProtoFileListing instance) {
            Path protoFilesRootValue;
            Objects.requireNonNull(instance, "instance");
            Path originalRootValue = instance.getOriginalRoot();
            if (originalRootValue != null) {
                this.originalRoot(originalRootValue);
            }
            if ((protoFilesRootValue = instance.getProtoFilesRoot()) != null) {
                this.protoFilesRoot(protoFilesRootValue);
            }
            this.addAllProtoFiles(instance.getProtoFiles());
            return this;
        }

        public final Builder originalRoot(Path originalRoot) {
            this.originalRoot = originalRoot;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder protoFilesRoot(Path protoFilesRoot) {
            this.protoFilesRoot = protoFilesRoot;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addProtoFiles(Path element) {
            this.protoFiles.add(element);
            return this;
        }

        public final Builder addProtoFiles(Path ... elements) {
            for (Path element : elements) {
                this.protoFiles.add(element);
            }
            return this;
        }

        public final Builder protoFiles(Iterable<? extends Path> elements) {
            this.protoFiles.clear();
            return this.addAllProtoFiles(elements);
        }

        public final Builder addAllProtoFiles(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.protoFiles.add(path);
            }
            return this;
        }

        public ImmutableProtoFileListing build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProtoFileListing(this.originalRoot, this.protoFilesRoot, ImmutableProtoFileListing.createUnmodifiableSet(this.protoFiles));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("originalRoot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("protoFilesRoot");
            }
            return "Cannot build ProtoFileListing, some of required attributes are not set " + attributes;
        }
    }
}

