/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.source;

import io.github.ascopes.protobufmavenplugin.source.ImmutableProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoArchiveExtractor;
import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoFilePredicates;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtoSourceResolver
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ProtoArchiveExtractor.class);
    private final ProtoArchiveExtractor protoArchiveExtractor;
    private final ExecutorService executorService;

    @Inject
    public ProtoSourceResolver(ProtoArchiveExtractor protoArchiveExtractor) {
        int concurrency = Runtime.getRuntime().availableProcessors() * 4;
        this.protoArchiveExtractor = protoArchiveExtractor;
        this.executorService = Executors.newWorkStealingPool(concurrency);
    }

    @Override
    @PreDestroy
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public Collection<ProtoFileListing> createProtoFileListings(Collection<Path> originalPaths) throws IOException {
        ArrayList<CompletableFuture<Optional<ProtoFileListing>>> futures = new ArrayList<CompletableFuture<Optional<ProtoFileListing>>>();
        for (Path originalPath : originalPaths) {
            futures.add(this.createProtoFileListingAsync(originalPath));
        }
        ArrayList<ProtoFileListing> results = new ArrayList<ProtoFileListing>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (CompletableFuture completableFuture : futures) {
            try {
                ((Optional)completableFuture.get()).ifPresent(results::add);
            }
            catch (InterruptedException | ExecutionException ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            IOException ex = new IOException("Failed to create listings asynchronously");
            exceptions.forEach(ex::addSuppressed);
            throw ex;
        }
        return results;
    }

    public Optional<ProtoFileListing> createProtoFileListing(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.protoArchiveExtractor.extractProtoFiles(path);
        }
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            Set protoFiles = stream.filter(ProtoFilePredicates::isProtoFile).peek(protoFile -> log.debug("Found proto file in root {}: {}", (Object)path, protoFile)).collect(Collectors.toUnmodifiableSet());
            if (protoFiles.isEmpty()) {
                Optional<ProtoFileListing> optional = Optional.empty();
                return optional;
            }
            ImmutableProtoFileListing listing = ImmutableProtoFileListing.builder().addAllProtoFiles(protoFiles).protoFilesRoot(path).originalRoot(path).build();
            Optional<ProtoFileListing> optional = Optional.of(listing);
            return optional;
        }
    }

    private CompletableFuture<Optional<ProtoFileListing>> createProtoFileListingAsync(Path originalPath) {
        CompletableFuture<Optional<ProtoFileListing>> completableFuture = new CompletableFuture<Optional<ProtoFileListing>>();
        this.executorService.submit(() -> {
            try {
                completableFuture.complete(this.createProtoFileListing(originalPath));
            }
            catch (Exception ex) {
                completableFuture.completeExceptionally(ex);
            }
        });
        return completableFuture;
    }
}

