/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.ImmutableGenerationRequest;
import io.github.ascopes.protobufmavenplugin.generate.SourceCodeGenerator;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.jspecify.annotations.Nullable;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Component
    private SourceCodeGenerator sourceCodeGenerator;
    @Parameter(required=true, readonly=true, defaultValue="${session}")
    private MavenSession session;
    @Parameter(required=true, property="protoc.version")
    private String protocVersion;
    @Parameter
    private @Nullable Set<String> sourceDirectories;
    @Parameter
    private @Nullable Set<String> additionalImportPaths;
    @Parameter
    private @Nullable Set<DefaultArtifactCoordinate> binaryMavenPlugins;
    @Parameter
    private @Nullable Set<String> binaryPathPlugins;
    @Parameter
    private @Nullable List<URL> binaryUrlPlugins;
    @Parameter
    private @Nullable Set<DefaultDependableCoordinate> jvmMavenPlugins;
    @Parameter
    private @Nullable String outputDirectory;
    @Parameter(defaultValue="false")
    private boolean fatalWarnings;
    @Parameter(defaultValue="true")
    private boolean javaEnabled;
    @Parameter(defaultValue="false")
    private boolean kotlinEnabled;
    @Parameter(defaultValue="false")
    private boolean liteOnly;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validate();
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        Path actualOutputDirectory = this.outputDirectory == null || this.outputDirectory.isBlank() ? this.defaultOutputDirectory(this.session) : Path.of(this.outputDirectory, new String[0]);
        Collection<Path> actualSourceDirectories = this.sourceDirectories == null ? List.of(this.defaultSourceDirectory(this.session)) : this.parsePaths(this.sourceDirectories);
        ImmutableGenerationRequest request = ImmutableGenerationRequest.builder().additionalImportPaths(this.parsePaths(this.additionalImportPaths)).binaryMavenPlugins(Objects.requireNonNullElse(this.binaryMavenPlugins, Set.of())).binaryPathPlugins(Objects.requireNonNullElse(this.binaryPathPlugins, Set.of())).binaryUrlPlugins(Objects.requireNonNullElse(this.binaryUrlPlugins, List.of())).jvmMavenPlugins(Objects.requireNonNullElse(this.jvmMavenPlugins, Set.of())).allowedDependencyScopes(this.allowedScopes()).isFatalWarnings(this.fatalWarnings).isJavaEnabled(this.javaEnabled).isKotlinEnabled(this.kotlinEnabled).isLiteEnabled(this.liteOnly).mavenSession(this.session).outputDirectory(actualOutputDirectory).protocVersion(this.protocVersion()).sourceRootRegistrar(this.sourceRootRegistrar()).sourceRoots(actualSourceDirectories).build();
        try {
            if (!this.sourceCodeGenerator.generate(request)) {
                throw new MojoExecutionException("Protoc invocation failed");
            }
        }
        catch (ResolutionException | IOException ex) {
            MojoFailureException mojoFailureException = new MojoFailureException((Object)this, ex.getMessage(), ex.getMessage());
            mojoFailureException.initCause((Throwable)ex);
            throw mojoFailureException;
        }
    }

    protected abstract SourceRootRegistrar sourceRootRegistrar();

    protected abstract Path defaultSourceDirectory(MavenSession var1);

    protected abstract Path defaultOutputDirectory(MavenSession var1);

    protected abstract Set<String> allowedScopes();

    protected void validate() {
        if (this.protocVersion.equalsIgnoreCase("latest")) {
            throw new IllegalArgumentException("Cannot use LATEST for the protoc version. Google has not released linear versions in the past, meaning that using LATEST will have unexpected behaviour.");
        }
        Optional.ofNullable(this.outputDirectory).map(x$0 -> Path.of(x$0, new String[0])).flatMap(FileUtils::getFileExtension).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory cannot be a path with a JAR file extension");
        });
    }

    private String protocVersion() {
        String overriddenVersion = System.getProperty("protoc.version");
        if (overriddenVersion != null) {
            return overriddenVersion;
        }
        return this.protocVersion;
    }

    private Collection<Path> parsePaths(@Nullable Collection<String> paths) {
        if (paths == null) {
            return List.of();
        }
        return paths.stream().map(x$0 -> Path.of(x$0, new String[0])).map(FileUtils::normalize).collect(Collectors.toUnmodifiableList());
    }
}

