/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformArtifactFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.dependency.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.platform.Digests;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;

@Named
public final class BinaryPluginResolver {
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final PlatformArtifactFactory platformDependencyFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public BinaryPluginResolver(MavenDependencyPathResolver mavenDependencyPathResolver, PlatformArtifactFactory platformDependencyFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.platformDependencyFactory = platformDependencyFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(MavenSession session, Collection<? extends ArtifactCoordinate> plugins) throws ResolutionException {
        return this.resolveAll(plugins, plugin -> this.resolveMavenPlugin(session, (ArtifactCoordinate)plugin));
    }

    public Collection<ResolvedPlugin> resolvePathPlugins(Collection<String> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolvePathPlugin);
    }

    public Collection<ResolvedPlugin> resolveUrlPlugins(Collection<URL> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolveUrlPlugin);
    }

    private ResolvedPlugin resolveMavenPlugin(MavenSession session, ArtifactCoordinate plugin) throws ResolutionException {
        String extension = plugin.getExtension().equals("jar") ? null : plugin.getExtension();
        plugin = this.platformDependencyFactory.createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), extension, plugin.getClassifier());
        Path path = this.mavenDependencyPathResolver.resolveArtifact(session, plugin);
        this.makeExecutable(path);
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin resolvePathPlugin(String binaryName) throws ResolutionException {
        Path path = this.systemPathResolver.resolve(binaryName).orElseThrow(() -> new ResolutionException("No executable '" + binaryName + "' was found on the system path"));
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin resolveUrlPlugin(URL url) throws ResolutionException {
        Path path = this.urlResourceFetcher.fetchFileFromUrl(url, ".exe");
        this.makeExecutable(path);
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin createResolvedPlugin(Path path) {
        return ImmutableResolvedPlugin.builder().id(Digests.sha1(path.toString())).path(path).build();
    }

    private <A> Collection<ResolvedPlugin> resolveAll(Collection<A> plugins, Resolver<A> resolver) throws ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (A plugin : plugins) {
            resolvedPlugins.add(resolver.resolve(plugin));
        }
        return Collections.unmodifiableCollection(resolvedPlugins);
    }

    private void makeExecutable(Path path) throws ResolutionException {
        try {
            FileUtils.makeExecutable(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
        }
    }

    @FunctionalInterface
    private static interface Resolver<A> {
        public ResolvedPlugin resolve(A var1) throws ResolutionException;
    }
}

