/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.ImmutableGenerationRequest;
import io.github.ascopes.protobufmavenplugin.generate.SourceCodeGenerator;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.jspecify.annotations.Nullable;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Component
    private SourceCodeGenerator sourceCodeGenerator;
    @Parameter(required=true, readonly=true, defaultValue="${session}")
    private MavenSession session;
    @Parameter(required=true, property="protoc.version")
    private String protocVersion;
    @Parameter
    private @Nullable List<Path> sourceDirectories;
    @Parameter
    private @Nullable List<Path> additionalImportPaths;
    @Parameter
    private @Nullable List<DefaultArtifactCoordinate> binaryMavenPlugins;
    @Parameter
    private @Nullable List<String> binaryPathPlugins;
    @Parameter
    private @Nullable List<URL> binaryUrlPlugins;
    @Parameter
    private @Nullable List<DefaultDependableCoordinate> jvmMavenPlugins;
    @Parameter
    private @Nullable Path outputDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnMissingSources;
    @Parameter(defaultValue="false")
    private boolean fatalWarnings;
    @Parameter(defaultValue="true")
    private boolean javaEnabled;
    @Parameter(defaultValue="false")
    private boolean kotlinEnabled;
    @Parameter(defaultValue="false")
    private boolean liteOnly;
    @Parameter(defaultValue="true")
    private boolean registerAsCompilationRoot;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validate();
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        ImmutableGenerationRequest request = ImmutableGenerationRequest.builder().additionalImportPaths(this.nonNullList(this.additionalImportPaths)).allowedDependencyScopes(this.allowedScopes()).binaryMavenPlugins(this.nonNullList(this.binaryMavenPlugins)).binaryPathPlugins(this.nonNullList(this.binaryPathPlugins)).binaryUrlPlugins(this.nonNullList(this.binaryUrlPlugins)).jvmMavenPlugins(this.nonNullList(this.jvmMavenPlugins)).isFailOnMissingSources(this.failOnMissingSources).isFatalWarnings(this.fatalWarnings).isJavaEnabled(this.javaEnabled).isKotlinEnabled(this.kotlinEnabled).isLiteEnabled(this.liteOnly).isRegisterAsCompilationRoot(this.registerAsCompilationRoot).mavenSession(this.session).outputDirectory(Objects.requireNonNullElseGet(this.outputDirectory, () -> this.defaultOutputDirectory(this.session))).protocVersion(this.protocVersion()).sourceRootRegistrar(this.sourceRootRegistrar()).sourceRoots(Objects.requireNonNullElseGet(this.sourceDirectories, () -> List.of(this.defaultSourceDirectory(this.session)))).build();
        try {
            if (!this.sourceCodeGenerator.generate(request)) {
                throw new MojoExecutionException("Protoc invocation failed");
            }
        }
        catch (ResolutionException | IOException ex) {
            MojoFailureException mojoFailureException = new MojoFailureException((Object)this, ex.getMessage(), ex.getMessage());
            mojoFailureException.initCause((Throwable)ex);
            throw mojoFailureException;
        }
    }

    protected abstract SourceRootRegistrar sourceRootRegistrar();

    protected abstract Path defaultSourceDirectory(MavenSession var1);

    protected abstract Path defaultOutputDirectory(MavenSession var1);

    protected abstract Set<String> allowedScopes();

    protected void validate() {
        if (this.protocVersion.equalsIgnoreCase("latest")) {
            throw new IllegalArgumentException("Cannot use LATEST for the protoc version. Google has not released linear versions in the past, meaning that using LATEST will have unexpected behaviour.");
        }
        Optional.ofNullable(this.outputDirectory).flatMap(FileUtils::getFileExtension).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory cannot be a path with a JAR file extension");
        });
    }

    private String protocVersion() {
        String overriddenVersion = System.getProperty("protoc.version");
        return Objects.requireNonNullElse(overriddenVersion, this.protocVersion);
    }

    private <T> List<T> nonNullList(@Nullable List<T> list) {
        return Objects.requireNonNullElseGet(list, List::of);
    }
}

