/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugin;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.ImmutableMavenArtifact;
import io.github.ascopes.protobufmavenplugin.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.dependency.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.plugin.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class BinaryPluginResolver {
    private final MavenDependencyPathResolver dependencyResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public BinaryPluginResolver(MavenDependencyPathResolver dependencyResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.dependencyResolver = dependencyResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(Collection<? extends MavenArtifact> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolveMavenPlugin);
    }

    public Collection<ResolvedPlugin> resolvePathPlugins(Collection<String> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolvePathPlugin);
    }

    public Collection<ResolvedPlugin> resolveUrlPlugins(Collection<URL> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolveUrlPlugin);
    }

    private ResolvedPlugin resolveMavenPlugin(MavenArtifact plugin) throws ResolutionException {
        ImmutableMavenArtifact.Builder pluginBuilder = ImmutableMavenArtifact.builder().from(plugin);
        if (plugin.getClassifier() == null) {
            String classifier = this.platformClassifierFactory.getClassifier(plugin.getArtifactId());
            pluginBuilder.classifier(classifier);
        }
        if (plugin.getType() == null) {
            pluginBuilder.type("exe");
        }
        plugin = pluginBuilder.build();
        Path path = this.dependencyResolver.resolveOne(plugin, DependencyResolutionDepth.DIRECT).iterator().next();
        this.makeExecutable(path);
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin resolvePathPlugin(String binaryName) throws ResolutionException {
        Path path = this.systemPathResolver.resolve(binaryName).orElseThrow(() -> new ResolutionException("No executable '" + binaryName + "' was found on the system path"));
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin resolveUrlPlugin(URL url) throws ResolutionException {
        Path path = this.urlResourceFetcher.fetchFileFromUrl(url, ".exe");
        this.makeExecutable(path);
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin createResolvedPlugin(Path path) {
        return ImmutableResolvedPlugin.builder().id(Digests.sha1(path.toString())).path(path).build();
    }

    private <A> Collection<ResolvedPlugin> resolveAll(Collection<A> plugins, Resolver<A> resolver) throws ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (A plugin : plugins) {
            resolvedPlugins.add(resolver.resolve(plugin));
        }
        return resolvedPlugins;
    }

    private void makeExecutable(Path path) throws ResolutionException {
        try {
            FileUtils.makeExecutable(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
        }
    }

    @FunctionalInterface
    private static interface Resolver<A> {
        public ResolvedPlugin resolve(A var1) throws ResolutionException;
    }
}

