/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugin;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugin.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class JvmPluginResolver {
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver dependencyResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, MavenDependencyPathResolver dependencyResolver, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.dependencyResolver = dependencyResolver;
        this.temporarySpace = temporarySpace;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(Collection<? extends MavenArtifact> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (MavenArtifact mavenArtifact : plugins) {
            resolvedPlugins.add(this.resolve(mavenArtifact));
        }
        return resolvedPlugins;
    }

    private ResolvedPlugin resolve(MavenArtifact plugin) throws IOException, ResolutionException {
        String pluginId = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(pluginId, argLine) : this.writeShellScript(pluginId, argLine);
        return ImmutableResolvedPlugin.builder().id(pluginId).path(scriptPath).build();
    }

    private List<String> resolveAndBuildArgLine(MavenArtifact plugin) throws ResolutionException {
        Iterator<Path> dependencyIterator = this.dependencyResolver.resolveOne(plugin, DependencyResolutionDepth.TRANSITIVE).iterator();
        Path pluginPath = dependencyIterator.next();
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        if (dependencyIterator.hasNext()) {
            args.add("-classpath");
            args.add(this.buildClasspath(dependencyIterator));
        }
        args.add("-jar");
        args.add(pluginPath.toString());
        return args;
    }

    private String buildClasspath(Iterator<Path> paths) {
        StringBuilder sb = new StringBuilder().append(paths.next());
        while (paths.hasNext()) {
            sb.append(":").append(paths.next());
        }
        return sb.toString();
    }

    private String pluginIdDigest(MavenArtifact plugin) {
        return Digests.sha1(plugin.toString());
    }

    private Path resolvePluginScriptPath() {
        return this.temporarySpace.createTemporarySpace("plugins", "jvm");
    }

    private Path writeWindowsBatchScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".bat");
        String script = "@echo off\r\n" + Shlex.quoteBatchArgs(argLine) + "\r\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        return fullScriptPath;
    }

    private Path writeShellScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".sh");
        String script = "#!/usr/bin/env sh\nset -eu\n" + Shlex.quoteShellArgs(argLine) + "\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.UTF_8, new OpenOption[0]);
        FileUtils.makeExecutable(fullScriptPath);
        return fullScriptPath;
    }
}

