/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class TemporarySpace {
    private static final String FRAG = "protobuf-maven-plugin";
    private static final Logger log = LoggerFactory.getLogger(TemporarySpace.class);
    private final MavenProject mavenProject;
    private final MojoExecution mojoExecution;

    @Inject
    public TemporarySpace(MavenProject mavenProject, MojoExecution mojoExecution) {
        this.mavenProject = mavenProject;
        this.mojoExecution = mojoExecution;
    }

    public Path createTemporarySpace(String ... bits) {
        String goal = Objects.requireNonNullElse(this.mojoExecution.getGoal(), "unknown-goal");
        String executionId = Objects.requireNonNullElse(this.mojoExecution.getExecutionId(), "unknown-execution-id");
        Path dir = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]).resolve(FRAG).resolve(goal).resolve(executionId);
        for (String bit : bits) {
            dir = dir.resolve(bit);
        }
        log.trace("Creating temporary directory at '{}' if it does not already exist...", (Object)dir);
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to create temporary directory!", ex);
        }
    }
}

